/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.linkedediting;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.operations.linkedediting.LSPLinkedEditingBase;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class LSPLinkedEditingAutoEditStrategy
extends LSPLinkedEditingBase
implements IAutoEditStrategy {
    private IDocument fDocument;
    private boolean fIsInstalled = false;
    private static final Comparator<Range> RANGE_OFFSET_ORDER = new RangeOffsetComparator();

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.checkCommand(command)) {
            return;
        }
        if (!this.isOffsetInRanges(document, command.offset)) {
            try {
                this.collectLinkedEditingRanges(document, command.offset).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        if (this.fLinkedEditingRanges == null) {
            return;
        }
        TreeSet<Range> sortedRanges = new TreeSet<Range>(RANGE_OFFSET_ORDER);
        sortedRanges.addAll(this.fLinkedEditingRanges.getRanges());
        int changeStart = Integer.MAX_VALUE;
        int changeEnd = Integer.MIN_VALUE;
        Range commandRange = null;
        int delta = 0;
        try {
            for (Range r : sortedRanges) {
                int end;
                int start = LSPEclipseUtils.toOffset(r.getStart(), document);
                if (changeStart > start) {
                    changeStart = start;
                }
                if (changeEnd < (end = LSPEclipseUtils.toOffset(r.getEnd(), document))) {
                    changeEnd = end;
                }
                if (start > command.offset || end < command.offset) continue;
                commandRange = r;
                delta = command.offset - start;
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return;
        }
        if (commandRange == null) {
            return;
        }
        StringBuilder text = new StringBuilder();
        int caretOffset = -1;
        try {
            int currentOffset = changeStart;
            for (Range r : sortedRanges) {
                int rangeStart = LSPEclipseUtils.toOffset(r.getStart(), document);
                int rangeEnd = LSPEclipseUtils.toOffset(r.getEnd(), document);
                if (currentOffset < rangeStart) {
                    text.append(document.get(currentOffset, rangeStart - currentOffset));
                }
                int rangeChangeEnd = rangeStart + delta + command.length;
                String rangeTextBeforeCommand = document.get(rangeStart, delta);
                String rangeTextAfterCommand = rangeEnd > rangeChangeEnd ? document.get(rangeChangeEnd, rangeEnd - rangeChangeEnd) : "";
                text.append(rangeTextBeforeCommand).append(command.text);
                if (r == commandRange) {
                    caretOffset = text.length();
                }
                text.append(rangeTextAfterCommand);
                int n = currentOffset = rangeEnd > rangeChangeEnd ? rangeEnd : rangeChangeEnd;
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return;
        }
        command.offset = changeStart;
        command.length = changeEnd - changeStart;
        command.text = text.toString();
        command.caretOffset = changeStart + caretOffset;
        command.shiftsCaret = false;
    }

    private boolean checkCommand(DocumentCommand command) {
        if (!this.fIsInstalled) {
            super.install();
            this.fIsInstalled = true;
        }
        return this.fEnabled && !command.text.chars().anyMatch(Character::isWhitespace);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOffsetInRanges(IDocument document, int offset) {
        if (this.fDocument != document) {
            this.fLinkedEditingRanges = null;
            this.fDocument = document;
            return false;
        }
        if (this.fLinkedEditingRanges == null) return false;
        try {
            Range r;
            Iterator iterator = this.fLinkedEditingRanges.getRanges().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (LSPEclipseUtils.toOffset((r = (Range)iterator.next()).getStart(), document) > offset || LSPEclipseUtils.toOffset(r.getEnd(), document) < offset);
            return true;
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return false;
    }

    private static class RangeOffsetComparator
    implements Comparator<Range> {
        private RangeOffsetComparator() {
        }

        @Override
        public int compare(Range r1, Range r2) {
            Position p1 = r1.getStart();
            Position p2 = r2.getStart();
            if (p1.getLine() == p2.getLine()) {
                return p1.getCharacter() - p2.getCharacter();
            }
            return p1.getLine() - p2.getLine();
        }
    }
}

