import { TextDocument } from 'vscode-languageserver-textdocument';
import { Diagnostic, DiagnosticSeverity, DiagnosticTag, Position, Range } from 'vscode-languageserver-types';
import { ValidationCode, ValidatorSettings } from './main';
export declare const KEYWORDS: string[];
export declare class Validator {
    private document;
    private settings;
    constructor(settings?: ValidatorSettings);
    private checkDirectives;
    /**
     * Checks the arguments of the given instruction.
     *
     * @param instruction the instruction to validate
     * @param problems an array of identified problems in the document
     * @param expectedArgCount an array of expected number of arguments
     *                         for the instruction, if its length is 1
     *                         and its value is -1, any number of
     *                         arguments greater than zero is valid
     * @param validate the function to use to validate an argument
     * @param createIncompleteDiagnostic the function to use to create a diagnostic
     *                                   if the number of arguments is incorrect
     */
    private checkArguments;
    private checkVariables;
    private checkProperty;
    validate(document: TextDocument): Diagnostic[];
    private validateInstruction;
    private hasHeredocs;
    private getDestinationArgument;
    private checkDestinationIsDirectory;
    private createDuplicatesDiagnostics;
    private checkJsonDestinationIsDirectory;
    private checkFlagValue;
    private checkFlagDuration;
    private static isNumberRelated;
    private checkDuplicateFlags;
    private checkJSON;
    private checkJSONQuotes;
    private static dockerProblems;
    private static formatMessage;
    static getDiagnosticMessage_DirectiveCasing(): string;
    static getDiagnosticMessage_DirectiveEscapeDuplicated(): string;
    static getDiagnosticMessage_DirectiveEscapeInvalid(value: string): string;
    static getDiagnosticMessage_NoSourceImage(): string;
    static getDiagnosticMessage_EmptyContinuationLine(): string;
    static getDiagnosticMessage_DuplicateBuildStageName(name: string): string;
    static getDiagnosticMessage_InvalidBuildStageName(name: string): string;
    static getDiagnosticMessage_FlagAtLeastOne(flagName: string, flagValue: string): string;
    static getDiagnosticMessage_FlagDuplicate(flag: string): string;
    static getDiagnosticMessage_FlagInvalidDuration(flag: string): string;
    static getDiagnosticMessage_FlagLessThan1ms(flag: string): string;
    static getDiagnosticMessage_FlagMissingDuration(duration: string): string;
    static getDiagnosticMessage_FlagInvalidFromValue(value: string): string;
    static getDiagnosticMessage_FlagMissingValue(flag: string): string;
    static getDiagnosticMessage_FlagUnknown(flag: string): string;
    static getDiagnosticMessage_FlagUnknownUnit(unit: string, duration: string): string;
    static getDiagnosticMessage_BaseNameEmpty(name: string): string;
    static getDiagnosticMessage_InvalidAs(): string;
    static getDiagnosticMessage_InvalidPort(port: string): string;
    static getDiagnosticMessage_InvalidProto(protocol: string): string;
    static getDiagnosticMessage_InvalidReferenceFormat(): string;
    static getDiagnosticMessage_InvalidSignal(signal: string): string;
    static getDiagnosticMessage_InvalidSyntax(syntax: string): string;
    static getDiagnosticMessage_InstructionExtraArgument(): string;
    static getDiagnosticMessage_InstructionMissingArgument(): string;
    static getDiagnosticMessage_ADDDestinationNotDirectory(): string;
    static getDiagnosticMessage_ADDRequiresAtLeastTwoArguments(): string;
    static getDiagnosticMessage_COPYDestinationNotDirectory(): string;
    static getDiagnosticMessage_COPYRequiresAtLeastTwoArguments(): string;
    static getDiagnosticMessage_HEALTHCHECKRequiresAtLeastOneArgument(): string;
    static getDiagnosticMessage_ENVRequiresTwoArguments(): string;
    static getDiagnosticMessage_InstructionRequiresOneOrThreeArguments(): string;
    static getDiagnosticMessage_HealthcheckNoneUnnecessaryArgument(): string;
    static getDiagnosticMessage_InstructionMultiple(instruction: string): string;
    static getDiagnosticMessage_InstructionUnknown(instruction: string): string;
    static getDiagnosticMessage_SyntaxMissingEquals(argument: string): string;
    static getDiagnosticMessage_SyntaxMissingNames(instruction: string): string;
    static getDiagnosticMessage_SyntaxMissingSingleQuote(key: string): string;
    static getDiagnosticMessage_SyntaxMissingDoubleQuote(key: string): string;
    static getDiagnosticMessage_InstructionCasing(): string;
    static getDiagnosticMessage_InstructionJSONInSingleQuotes(): string;
    static getDiagnosticMessage_OnbuildChainingDisallowed(): string;
    static getDiagnosticMessage_OnbuildTriggerDisallowed(trigger: string): string;
    static getDiagnosticMessage_VariableModifierUnsupported(variable: string, modifier: string): string;
    static getDiagnosticMessage_ShellJsonForm(): string;
    static getDiagnosticMessage_ShellRequiresOne(): string;
    static getDiagnosticMessage_DeprecatedMaintainer(): string;
    static getDiagnosticMessage_HealthcheckCmdArgumentMissing(): string;
    static getDiagnosticMessage_HealthcheckTypeUnknown(type: string): string;
    static getDiagnosticMessage_WORKDIRPathNotAbsolute(): string;
    private static createDuplicatedEscapeDirective;
    static createInvalidEscapeDirective(start: Position, end: Position, value: string): Diagnostic;
    private static createDuplicateBuildStageName;
    private static createInvalidBuildStageName;
    static createFlagAtLeastOne(start: Position, end: Position, flagName: string, flagValue: string): Diagnostic;
    static createFlagDuplicate(start: Position, end: Position, flag: string): Diagnostic;
    private static createFlagInvalidDuration;
    private static createFlagLessThan1ms;
    private static createFlagMissingDuration;
    private static createFlagInvalidFrom;
    static createFlagMissingValue(start: Position, end: Position, flag: string): Diagnostic;
    static createUnknownAddFlag(start: Position, end: Position, flag: string): Diagnostic;
    static createUnknownCopyFlag(start: Position, end: Position, flag: string): Diagnostic;
    static createUnknownFromFlag(start: Position, end: Position, flag: string): Diagnostic;
    static createUnknownHealthcheckFlag(start: Position, end: Position, flag: string): Diagnostic;
    private static createFlagUnknownUnit;
    private static createBaseNameEmpty;
    static createInvalidAs(start: Position, end: Position): Diagnostic;
    static createInvalidPort(range: Range, port: string): Diagnostic;
    private static createInvalidProto;
    private static createInvalidReferenceFormat;
    static createInvalidStopSignal(start: Position, end: Position, signal: string): Diagnostic;
    static createInvalidSyntax(start: Position, end: Position, syntax: string): Diagnostic;
    static createMissingArgument(start: Position, end: Position): Diagnostic;
    static createExtraArgument(start: Position, end: Position): Diagnostic;
    private static createHealthcheckNoneUnnecessaryArgument;
    private static createADDDestinationNotDirectory;
    private static createADDRequiresAtLeastTwoArguments;
    private static createCOPYDestinationNotDirectory;
    private static createCOPYRequiresAtLeastTwoArguments;
    static createENVRequiresTwoArguments(start: Position, end: Position): Diagnostic;
    private static createHEALTHCHECKRequiresAtLeastOneArgument;
    private static createHealthcheckCmdArgumentMissing;
    private static createHealthcheckTypeUnknown;
    private static createOnbuildChainingDisallowed;
    private static createOnbuildTriggerDisallowed;
    private static createShellJsonForm;
    private static createShellRequiresOne;
    static createRequiresOneOrThreeArguments(start: Position, end: Position): Diagnostic;
    static createNoSourceImage(start: Position, end: Position): Diagnostic;
    static createSyntaxMissingEquals(start: Position, end: Position, argument: string): Diagnostic;
    private static createSyntaxMissingSingleQuote;
    private static createSyntaxMissingDoubleQuote;
    private static createSyntaxMissingNames;
    private static createVariableUnsupportedModifier;
    static createUnknownInstruction(start: Position, end: Position, instruction: string): Diagnostic;
    static createError(start: Position, end: Position, description: string, code?: ValidationCode, tags?: DiagnosticTag[]): Diagnostic;
    private static createJSONInSingleQuotes;
    private static createEmptyContinuationLine;
    private createMultipleInstructions;
    private createLowercaseDirective;
    createUppercaseInstruction(start: Position, end: Position): Diagnostic | null;
    createMaintainerDeprecated(start: Position, end: Position): Diagnostic | null;
    private createWORKDIRNotAbsolute;
    static createWarning(start: Position, end: Position, description: string, code?: ValidationCode, tags?: DiagnosticTag[]): Diagnostic;
    static createDiagnostic(severity: DiagnosticSeverity, start: Position, end: Position, description: string, code?: ValidationCode, tags?: DiagnosticTag[]): Diagnostic;
}
