/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.state;

import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.IPropertyState;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingParameterStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingUse;
import org.eclipse.jst.ws.jaxws.dom.runtime.util.Jee5DomUtils;

public class ParameterPropertyStateAdapter
extends AdapterImpl
implements IPropertyState {
    public boolean isChangeable(EStructuralFeature feature) {
        assert (this.getTarget() instanceof IWebParam);
        IWebParam webParam = (IWebParam)this.getTarget();
        if (webParam.getImplementation().equals("return")) {
            return false;
        }
        if (this.isOutsideInWebService(webParam)) {
            return false;
        }
        switch (feature.getFeatureID()) {
            case 1: {
                return this.isNameChangeable(webParam);
            }
            case 4: {
                return this.isPartNameChangeable(webParam);
            }
            case 5: {
                return this.isTargetNSChangeable(webParam);
            }
        }
        return false;
    }

    protected boolean isPartNameChangeable(IWebParam webParam) {
        IWebMethod webMethod = (IWebMethod)webParam.eContainer();
        return webMethod.getSoapBindingStyle() == SOAPBindingStyle.RPC && webMethod.getSoapBindingUse() == SOAPBindingUse.LITERAL && webMethod.getSoapBindingParameterStyle() == SOAPBindingParameterStyle.WRAPPED;
    }

    protected boolean isNameChangeable(IWebParam webParam) {
        IWebMethod webMethod = (IWebMethod)webParam.eContainer();
        if (this.isDocumentLiteralWrapped(webMethod)) {
            return true;
        }
        if (Jee5DomUtils.getInstance().isNameRequired(webParam)) {
            return true;
        }
        return webParam.isHeader();
    }

    protected boolean isTargetNSChangeable(IWebParam webParam) {
        IWebMethod webMethod = (IWebMethod)webParam.eContainer();
        if (this.isDocumentLiteralWrapped(webMethod)) {
            return true;
        }
        return webParam.isHeader();
    }

    protected boolean isDocumentLiteralWrapped(IWebMethod webMethod) {
        return webMethod.getSoapBindingStyle() != SOAPBindingStyle.RPC && webMethod.getSoapBindingUse() != SOAPBindingUse.ENCODED && webMethod.getSoapBindingParameterStyle() != SOAPBindingParameterStyle.BARE;
    }

    protected boolean isOutsideInWebService(IWebParam webParam) {
        IServiceEndpointInterface sei = (IServiceEndpointInterface)webParam.eContainer().eContainer();
        return DomUtil.INSTANCE.isOutsideInWebService(sei);
    }

    public boolean isAdapterForType(Object type) {
        return IPropertyState.class == type;
    }
}

