/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.ui.widgets;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.internal.cxf.ui.viewers.PackageNameEditingSupport;
import org.eclipse.jst.ws.internal.cxf.ui.viewers.PackageNameTableContentProvider;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.WSDL2JavaWidgetFactory;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class WSDL2JavaConfigWidget
extends SimpleWidgetDataContributor {
    private IStatus status = Status.OK_STATUS;
    private Composite parent;
    private Listener statusListener;
    private WSDL2JavaDataModel model;
    private Combo outputDirCombo;
    private Text packageNameText;
    private Button namespaceMappingButton;
    private TableViewer packageNameTableViewer;
    private Combo serviceNameCombo;
    private List bindingFilesList;
    private Composite namespaceCompositeHolder;
    private Composite namespaceComposite;
    private int namespaceCompositeHeight = -1;

    public void setWSDL2JavaDataModel(WSDL2JavaDataModel model) {
        this.model = model;
    }

    public void internalize() {
        WSDL2JavaWidgetFactory.populateOutputDirectoryCombo((Combo)this.outputDirCombo, (String)this.model.getProjectName());
        this.packageNameText.setText((String)this.model.getIncludedNamespaces().get(this.model.getTargetNamespace()));
        this.namespaceMappingButton.setSelection(false);
        this.expandNamespaceComposite(false);
        if (this.packageNameTableViewer != null && this.packageNameTableViewer.getContentProvider() != null) {
            this.packageNameTableViewer.setInput((Object)this.model.getWsdlDefinition());
        }
        WSDL2JavaWidgetFactory.populateServiceNameCombo((Combo)this.serviceNameCombo, (WSDL2JavaDataModel)this.model);
        this.bindingFilesList.removeAll();
    }

    public WidgetDataEvents addControls(Composite parent, final Listener statusListener) {
        this.parent = parent;
        this.statusListener = statusListener;
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        mainComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        mainComposite.setLayoutData((Object)gridData);
        WSDL2JavaWidgetFactory.createOutputDirectoryLabel((Composite)mainComposite);
        this.outputDirCombo = WSDL2JavaWidgetFactory.createOutputDirectoryCombo((Composite)mainComposite, (WSDL2JavaDataModel)this.model);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.outputDirCombo.setLayoutData((Object)gridData);
        WSDL2JavaWidgetFactory.createPackageNameLabel((Composite)mainComposite);
        this.packageNameText = WSDL2JavaWidgetFactory.createPackageNameText((Composite)mainComposite, (WSDL2JavaDataModel)this.model);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.packageNameText.setLayoutData((Object)gridData);
        this.packageNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String packageName = WSDL2JavaConfigWidget.this.packageNameText.getText();
                WSDL2JavaConfigWidget.this.status = JDTUtils.validatePackageName((String)WSDL2JavaConfigWidget.this.model.getProjectName(), (String)packageName);
                statusListener.handleEvent(null);
            }
        });
        this.namespaceMappingButton = WSDL2JavaWidgetFactory.createNamespacePackageMappingButton((Composite)mainComposite);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 3;
        this.namespaceMappingButton.setLayoutData((Object)gridData);
        this.namespaceMappingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDL2JavaConfigWidget.this.expandNamespaceComposite(WSDL2JavaConfigWidget.this.namespaceMappingButton.getSelection());
            }
        });
        this.namespaceCompositeHolder = new Composite(mainComposite, 0);
        gridLayout = new GridLayout(1, true);
        this.namespaceCompositeHolder.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 3;
        this.namespaceCompositeHolder.setLayoutData((Object)gridData);
        WSDL2JavaWidgetFactory.createServiceNameLabel((Composite)mainComposite);
        this.serviceNameCombo = WSDL2JavaWidgetFactory.createServiceNameCombo((Composite)mainComposite, (WSDL2JavaDataModel)this.model);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.serviceNameCombo.setLayoutData((Object)gridData);
        Label bindingFilesLabel = WSDL2JavaWidgetFactory.createBindingFilesLabel((Composite)mainComposite);
        gridData = new GridData(4, 4, false, false);
        gridData.verticalSpan = 3;
        bindingFilesLabel.setLayoutData((Object)gridData);
        this.bindingFilesList = WSDL2JavaWidgetFactory.createBindingFilesList((Composite)mainComposite);
        gridData = new GridData(4, 4, true, false);
        gridData.verticalSpan = 3;
        this.bindingFilesList.setLayoutData((Object)gridData);
        Button addBindingFileButton = WSDL2JavaWidgetFactory.createAddBindingFileButton((Composite)mainComposite, (WSDL2JavaDataModel)this.model, (List)this.bindingFilesList);
        gridData = new GridData(4, 4, false, false);
        addBindingFileButton.setLayoutData((Object)gridData);
        Button removeBindingFileButton = WSDL2JavaWidgetFactory.createRemoveBindingFileButton((Composite)mainComposite, (WSDL2JavaDataModel)this.model, (List)this.bindingFilesList);
        gridData = new GridData(4, 4, false, false);
        removeBindingFileButton.setLayoutData((Object)gridData);
        WSDL2JavaWidgetFactory.createPaddingLabel((Composite)mainComposite);
        return this;
    }

    private void expandNamespaceComposite(boolean expand) {
        if (expand) {
            if (this.namespaceComposite == null) {
                GridData gridData = new GridData(4, 4, true, false);
                gridData.horizontalSpan = 3;
                gridData.verticalSpan = 7;
                this.namespaceCompositeHolder.setLayoutData((Object)gridData);
                this.namespaceCompositeHolder.pack();
                this.namespaceComposite = this.getNamespaceMappingComposite(this.namespaceCompositeHolder);
                if (this.namespaceCompositeHeight == -1) {
                    Point groupSize = this.namespaceComposite.computeSize(-1, -1, true);
                    this.namespaceCompositeHeight = groupSize.y;
                }
                Shell shell = this.parent.getShell();
                Point shellSize = shell.getSize();
                shell.setSize(shellSize.x, shellSize.y + this.namespaceCompositeHeight);
                this.namespaceCompositeHolder.layout();
            }
        } else if (this.namespaceComposite != null) {
            GridData gridData = new GridData(4, 4, false, false);
            gridData.horizontalSpan = 3;
            this.namespaceCompositeHolder.setLayoutData((Object)gridData);
            this.namespaceCompositeHolder.pack();
            this.namespaceComposite.dispose();
            this.namespaceComposite = null;
            this.namespaceCompositeHolder.layout();
            Shell shell = this.parent.getShell();
            Point shellSize = shell.getSize();
            shell.setSize(shellSize.x, shellSize.y - this.namespaceCompositeHeight);
        }
    }

    private Composite getNamespaceMappingComposite(Composite parent) {
        this.namespaceComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        this.namespaceComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        this.namespaceComposite.setLayoutData((Object)gridData);
        Table packageNameTable = this.createNamespaceMappingTable(this.namespaceComposite);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 6;
        packageNameTable.setLayoutData((Object)gridData);
        return this.namespaceComposite;
    }

    private Table createNamespaceMappingTable(Composite parent) {
        this.packageNameTableViewer = new TableViewer(parent, 67618);
        Table packageNameTable = this.packageNameTableViewer.getTable();
        packageNameTable.setLinesVisible(true);
        packageNameTable.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        packageNameTable.setLayout((Layout)tableLayout);
        WSDL2JavaWidgetFactory.createWSDLNamespaceViewerColumn((TableViewer)this.packageNameTableViewer);
        ColumnWeightData columnWeightData = new ColumnWeightData(100, 100, true);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableViewerColumn packageNameViewerColumn = WSDL2JavaWidgetFactory.createPackageNameColumn((TableViewer)this.packageNameTableViewer, (WSDL2JavaDataModel)this.model);
        TextCellEditor textCellEditor = new TextCellEditor((Composite)this.packageNameTableViewer.getTable());
        textCellEditor.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                WSDL2JavaConfigWidget.this.statusListener.handleEvent(null);
            }

            public void cancelEditor() {
            }

            public void applyEditorValue() {
            }
        });
        textCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object packageName) {
                WSDL2JavaConfigWidget.this.status = JDTUtils.validatePackageName((String)WSDL2JavaConfigWidget.this.model.getProjectName(), (String)packageName.toString());
                if (WSDL2JavaConfigWidget.this.status.getSeverity() == 0) {
                    return null;
                }
                return WSDL2JavaConfigWidget.this.status.getMessage();
            }
        });
        packageNameViewerColumn.setEditingSupport((EditingSupport)new PackageNameEditingSupport(this.packageNameTableViewer, (CellEditor)textCellEditor, this.model));
        columnWeightData = new ColumnWeightData(100, 100, true);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        this.packageNameTableViewer.setContentProvider((IContentProvider)new PackageNameTableContentProvider());
        this.packageNameTableViewer.setInput((Object)this.model.getWsdlDefinition());
        TableItem[] tableItems = packageNameTable.getItems();
        int i = 0;
        while (i < tableItems.length) {
            TableItem tableItem = tableItems[i];
            if (this.model.getIncludedNamespaces().containsKey(tableItem.getText(0))) {
                tableItem.setChecked(true);
            }
            ++i;
        }
        return packageNameTable;
    }

    public IStatus getStatus() {
        return this.status;
    }
}

