/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.jee.project.facet.IAppClientCreateDeploymentFilesDataModelProperties;
import org.eclipse.jst.jee.project.facet.IConnectorCreateDeploymentFilesDataModelProperties;
import org.eclipse.jst.jee.project.facet.IEJBCreateDeploymentFilesDataModelProperties;
import org.eclipse.jst.jee.project.facet.IEarCreateDeploymentFilesDataModelProperties;
import org.eclipse.jst.jee.project.facet.IWebCreateDeploymentFilesDataModelProperties;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class CreateDeploymentDescriptorCommand
extends AbstractDataModelOperation {
    private IProject project;

    public CreateDeploymentDescriptorCommand() {
    }

    public CreateDeploymentDescriptorCommand(IDataModel model) {
        super(model);
    }

    public void setServerProject(IProject serverProject) {
        this.project = serverProject;
    }

    protected boolean hasDeploymentDescriptor(IProject project) {
        boolean ret = true;
        Path ddFilePath = null;
        if (JavaEEProjectUtilities.isEARProject((IProject)project)) {
            ddFilePath = new Path("META-INF/application.xml");
        } else if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
            ddFilePath = new Path("META-INF/ejb-jar.xml");
        } else if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            ddFilePath = new Path("WEB-INF/web.xml");
        } else if (JavaEEProjectUtilities.isApplicationClientProject((IProject)project)) {
            ddFilePath = new Path("META-INF/application-client.xml");
        } else if (JavaEEProjectUtilities.isJCAProject((IProject)project)) {
            ddFilePath = new Path("META-INF/ra.xml");
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component.getRootFolder() != null && component.getRootFolder().getUnderlyingFolder() != null) {
            IFile ddXmlFile = component.getRootFolder().getUnderlyingFolder().getFile((IPath)ddFilePath);
            ret = ddXmlFile.exists();
        }
        return ret;
    }

    protected IDataModel getDataModel(IProject project) {
        Class<IEarCreateDeploymentFilesDataModelProperties> dataModelClass = null;
        if (JavaEEProjectUtilities.isEARProject((IProject)project)) {
            dataModelClass = IEarCreateDeploymentFilesDataModelProperties.class;
        } else if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
            dataModelClass = IEJBCreateDeploymentFilesDataModelProperties.class;
        } else if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            dataModelClass = IWebCreateDeploymentFilesDataModelProperties.class;
        } else if (JavaEEProjectUtilities.isApplicationClientProject((IProject)project)) {
            dataModelClass = IAppClientCreateDeploymentFilesDataModelProperties.class;
        } else if (JavaEEProjectUtilities.isJCAProject((IProject)project)) {
            dataModelClass = IConnectorCreateDeploymentFilesDataModelProperties.class;
        }
        IDataModel dataModel = DataModelFactory.createDataModel(dataModelClass);
        dataModel.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)project);
        return dataModel;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        IEnvironment environment = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        if (this.project != null && !this.hasDeploymentDescriptor(this.project)) {
            try {
                this.getDataModel(this.project).getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                status = StatusUtils.errorStatus((String)e.getMessage(), (Throwable)e);
            }
        }
        if (status.getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
            return status;
        }
        return status;
    }
}

