/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatWebModule;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.jst.server.tomcat.ui.internal.Messages;
import org.eclipse.jst.server.tomcat.ui.internal.TomcatUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class CleanWorkDirDialog
extends Dialog {
    protected IServer server;
    protected IModule module;
    protected int state;
    protected String mode;
    protected IStatus completionStatus;

    public CleanWorkDirDialog(Shell parentShell, IServer server, IModule module) {
        super(parentShell);
        if (server == null) {
            throw new IllegalArgumentException();
        }
        this.server = server;
        this.module = module;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.confirmCleanWorkDirTitle);
    }

    protected Control createDialogArea(Composite parent) {
        if (this.state < 0 || this.state == 0) {
            this.captureServerState();
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jst.server.tomcat.ui.tvcp0000");
        Label label = new Label(composite, 64);
        if (this.state == 1 || this.state == 3 || this.state == 0) {
            label.setText(NLS.bind((String)Messages.cleanServerStateChanging, (Object)this.server.getName()));
        } else {
            if (this.module != null) {
                label.setText(NLS.bind((String)Messages.cleanModuleWorkDir, (Object)this.module.getName(), (Object)this.server.getName()));
            } else {
                label.setText(NLS.bind((String)Messages.cleanServerWorkDir, (Object)this.server.getName()));
            }
            GridData data = new GridData();
            data.widthHint = 300;
            label.setLayoutData((Object)data);
            if (this.state == 2) {
                label = new Label(composite, 64);
                label.setText(Messages.cleanServerRunning);
                data = new GridData();
                data.widthHint = 300;
                label.setLayoutData((Object)data);
            }
        }
        CleanWorkDirDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button;
        super.createButtonsForButtonBar(parent);
        if (this.state < 0 || this.state == 0) {
            this.captureServerState();
        }
        if ((this.state == 1 || this.state == 3) && (button = this.getButton(0)) != null) {
            button.setEnabled(false);
        }
    }

    protected void okPressed() {
        String jobName = NLS.bind((String)Messages.cleanServerTask, (Object)(this.module != null ? this.module.getName() : this.server.getName()));
        CleanWorkDirJob job = new CleanWorkDirJob(jobName);
        job.schedule();
        super.okPressed();
    }

    private void captureServerState() {
        this.state = this.server.getServerState();
        if (this.state != 4) {
            this.mode = this.server.getMode();
        }
    }

    protected IStatus newErrorStatus(String message, Throwable throwable) {
        return new Status(4, "org.eclipse.jst.server.tomcat.ui", 0, message, throwable);
    }

    protected IStatus wrapErrorStatus(IStatus status, String message) {
        MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.ui", 0, message, null);
        ms.add(status);
        return ms;
    }

    class CleanWorkDirJob
    extends Job {
        public CleanWorkDirJob(String jobName) {
            super(jobName);
        }

        public boolean belongsTo(Object family) {
            return ServerUtil.SERVER_JOB_FAMILY.equals(family);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            final Object mutex = new Object();
            IWebModule webModule = null;
            if (CleanWorkDirDialog.this.module != null && (webModule = (IWebModule)CleanWorkDirDialog.this.module.loadAdapter(IWebModule.class, null)) == null) {
                return CleanWorkDirDialog.this.newErrorStatus(NLS.bind((String)Messages.errorCantIdentifyWebApp, (Object)CleanWorkDirDialog.this.module.getName()), null);
            }
            if (CleanWorkDirDialog.this.server.getServerState() != CleanWorkDirDialog.this.state) {
                return CleanWorkDirDialog.this.newErrorStatus(NLS.bind((String)Messages.errorCouldNotCleanStateChange, (Object)CleanWorkDirDialog.this.server.getName()), null);
            }
            IServer.IOperationListener listener = new IServer.IOperationListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IStatus result) {
                    Object object = mutex;
                    synchronized (object) {
                        ((CleanWorkDirJob)CleanWorkDirJob.this).CleanWorkDirDialog.this.completionStatus = result;
                        mutex.notifyAll();
                    }
                }
            };
            boolean restart = false;
            IStatus status = Status.OK_STATUS;
            if (CleanWorkDirDialog.this.state != 4) {
                status = CleanWorkDirDialog.this.server.canStop();
                if (!status.isOK()) {
                    return CleanWorkDirDialog.this.wrapErrorStatus(status, NLS.bind((String)Messages.errorCouldNotCleanCantStop, (Object)CleanWorkDirDialog.this.server.getName()));
                }
                boolean done = false;
                boolean force = false;
                while (!done) {
                    Object object = mutex;
                    synchronized (object) {
                        CleanWorkDirDialog.this.server.stop(force, listener);
                        while (CleanWorkDirDialog.this.completionStatus == null) {
                            try {
                                mutex.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (force || !CleanWorkDirDialog.this.completionStatus.isOK() || CleanWorkDirDialog.this.server.getServerState() == 4) {
                        done = true;
                        continue;
                    }
                    force = TomcatUIPlugin.queryCleanTermination(CleanWorkDirDialog.this.server);
                    CleanWorkDirDialog.this.completionStatus = null;
                }
                if (!CleanWorkDirDialog.this.completionStatus.isOK()) {
                    return Status.OK_STATUS;
                }
                if (CleanWorkDirDialog.this.server.getServerState() != 4) {
                    return CleanWorkDirDialog.this.newErrorStatus(NLS.bind((String)Messages.errorCouldNotCleanStopFailed, (Object)CleanWorkDirDialog.this.server.getName()), null);
                }
                restart = true;
                CleanWorkDirDialog.this.completionStatus = null;
            }
            DeleteWorkDirJob deleteJob = new DeleteWorkDirJob(this.getName(), webModule, restart);
            deleteJob.setRule(ServerUtil.getServerSchedulingRule((IServer)CleanWorkDirDialog.this.server));
            deleteJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    Object object = mutex;
                    synchronized (object) {
                        ((CleanWorkDirJob)CleanWorkDirJob.this).CleanWorkDirDialog.this.completionStatus = event.getResult();
                        mutex.notifyAll();
                    }
                }
            });
            Object object = mutex;
            synchronized (object) {
                deleteJob.schedule();
                while (CleanWorkDirDialog.this.completionStatus == null) {
                    try {
                        mutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!CleanWorkDirDialog.this.completionStatus.isOK()) {
                return Status.OK_STATUS;
            }
            CleanWorkDirDialog.this.completionStatus = null;
            if (restart) {
                status = CleanWorkDirDialog.this.server.canStart(CleanWorkDirDialog.this.mode);
                if (!status.isOK()) {
                    return CleanWorkDirDialog.this.wrapErrorStatus(status, NLS.bind((String)Messages.errorCleanCantRestart, (Object)CleanWorkDirDialog.this.server.getName()));
                }
                object = mutex;
                synchronized (object) {
                    CleanWorkDirDialog.this.server.start(CleanWorkDirDialog.this.mode, listener);
                    while (CleanWorkDirDialog.this.completionStatus == null) {
                        try {
                            mutex.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (!CleanWorkDirDialog.this.completionStatus.isOK()) {
                    return Status.OK_STATUS;
                }
            }
            return status;
        }
    }

    class DeleteWorkDirJob
    extends Job {
        private IWebModule webModule;
        private boolean restart;

        public DeleteWorkDirJob(String jobName, IWebModule webModule, boolean restart) {
            super(jobName);
            this.webModule = webModule;
            this.restart = restart;
        }

        public boolean belongsTo(Object family) {
            return ServerUtil.SERVER_JOB_FAMILY.equals(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            if (CleanWorkDirDialog.this.server.getServerState() != 4) {
                return CleanWorkDirDialog.this.newErrorStatus(NLS.bind((String)Messages.errorCantDeleteServerNotStopped, (Object)(this.webModule != null ? CleanWorkDirDialog.this.module.getName() : CleanWorkDirDialog.this.server.getName())), null);
            }
            TomcatServerBehaviour tsb = (TomcatServerBehaviour)CleanWorkDirDialog.this.server.loadAdapter(TomcatServerBehaviour.class, monitor);
            try {
                if (this.webModule != null) {
                    WebModule tcWebModule = new WebModule(this.webModule.getContextRoot(), "", "", true);
                    status = tsb.cleanContextWorkDir((ITomcatWebModule)tcWebModule, null);
                } else {
                    status = tsb.cleanServerWorkDir(null);
                }
            }
            catch (CoreException ce) {
                status = ce.getStatus();
            }
            if (!status.isOK()) {
                String cleanName = CleanWorkDirDialog.this.module != null ? CleanWorkDirDialog.this.module.getName() : CleanWorkDirDialog.this.server.getName();
                return CleanWorkDirDialog.this.wrapErrorStatus(status, this.restart ? NLS.bind((String)Messages.errorErrorDuringCleanWasRunning, (Object)cleanName, (Object)CleanWorkDirDialog.this.server.getName()) : NLS.bind((String)Messages.errorErrorDuringClean, (Object)cleanName));
            }
            return status;
        }
    }
}

