/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.widget;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFont;
import org.eclipse.jst.pagedesigner.css2.provider.DimensionInfo;
import org.eclipse.jst.pagedesigner.css2.style.DefaultStyle;
import org.eclipse.jst.pagedesigner.css2.widget.AbstractWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.BorderUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ListWidgetProvider
extends AbstractWidgetProvider {
    private static int DEFAULTSIZE = 4;
    private static final int VERTICAL_PADDING = 6;
    private static final int HORIZONTAL_PADDING = 12;
    private static int ARRAWWIDTH = 16;
    private static int ARROWHEIGHT = 16;
    private String[] _options;
    private int _rows = DEFAULTSIZE;

    public ListWidgetProvider(ICSSStyle style) {
        super(style);
    }

    public DimensionInfo getPreferredDimension(int width, int height) {
        if (width <= 0) {
            width = this.getDefaultWidth();
        }
        if (height <= 0) {
            height = this.getDefaultHeight();
        }
        return new DimensionInfo(width, height, -1);
    }

    public int getDefaultWidth() {
        int longestStringWidth = 0;
        if (this._options != null) {
            ICSSStyle style = this.getCSSStyle();
            if (style == null) {
                style = DefaultStyle.getInstance();
            }
            ICSSFont font = style.getCSSFont();
            Font swtFont = font.getSwtFont();
            int i = 0;
            while (i < this._options.length) {
                int width = FigureUtilities.getTextWidth((String)this._options[i], (Font)swtFont);
                if (width > longestStringWidth) {
                    longestStringWidth = width;
                }
                ++i;
            }
        }
        return longestStringWidth + 12 + ARRAWWIDTH;
    }

    public int getDefaultHeight() {
        ICSSStyle style = this.getCSSStyle();
        if (style == null) {
            style = DefaultStyle.getInstance();
        }
        ICSSFont font = style.getCSSFont();
        Font swtfont = font.getSwtFont();
        int fontHeight = FigureUtilities.getFontMetrics((Font)swtfont).getHeight();
        return fontHeight * this._rows + 6;
    }

    public void paintFigure(Graphics g, Rectangle rect) {
        BorderUtil.drawBorder(g, rect.x, rect.y, rect.width, rect.height, 2, true);
        if (this._options != null) {
            ICSSStyle style = this.getCSSStyle();
            if (style == null) {
                style = DefaultStyle.getInstance();
            }
            ICSSFont font = style.getCSSFont();
            Font swtfont = font.getSwtFont();
            g.setFont(swtfont);
            Color newColor = null;
            Object color = style.getColor();
            if (color instanceof Color) {
                g.setForegroundColor((Color)color);
            } else if (color instanceof RGB) {
                newColor = new Color((Device)Display.getCurrent(), (RGB)color);
                g.setForegroundColor(newColor);
            } else {
                g.setForegroundColor(ColorConstants.black);
            }
            int fontHeight = FigureUtilities.getFontMetrics((Font)swtfont).getHeight();
            int x = rect.x + 6;
            int y = rect.y + 3;
            g.clipRect(rect);
            int i = 0;
            while (i < this._options.length && i * fontHeight < rect.height - 6) {
                g.drawString(this._options[i], x, y);
                y += fontHeight;
                ++i;
            }
            if (newColor != null) {
                newColor.dispose();
            }
            int borderThick = 2;
            Rectangle barRect = new Rectangle(rect.x, rect.y + borderThick, rect.width - borderThick, rect.height - 2 * borderThick);
            BorderUtil.drawVertialBar(g, ARRAWWIDTH, ARROWHEIGHT, borderThick, barRect);
        }
    }

    private String normalize(String string) {
        if (string == null) {
            return "";
        }
        int index = string.indexOf(13);
        if (index >= 0) {
            string = string.substring(0, index);
        }
        if ((index = string.indexOf(10)) >= 0) {
            string = string.substring(0, index);
        }
        return string;
    }

    public void setOptions(String[] options) {
        this._options = options;
        if (this._options != null) {
            int i = 0;
            while (i < this._options.length) {
                this._options[i] = this.normalize(this._options[i]);
                ++i;
            }
        }
    }

    public void setRows(int rows) {
        this._rows = rows > 0 ? rows : DEFAULTSIZE;
    }

    public boolean isHandlingBorder() {
        return false;
    }
}

