/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.widget;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.provider.DimensionInfo;
import org.eclipse.jst.pagedesigner.css2.widget.AbstractWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.BorderUtil;
import org.eclipse.swt.widgets.Display;

public class CheckboxWidgetProvider
extends AbstractWidgetProvider {
    private boolean isChecked;

    public CheckboxWidgetProvider(ICSSStyle style) {
        super(style);
    }

    public DimensionInfo getPreferredDimension(int width, int height) {
        if (width <= 0) {
            width = this.getDefaultWidth();
        }
        if (height <= 0) {
            height = this.getDefaultWidth();
        }
        return new DimensionInfo(new Dimension(width, height), height * 4 / 5);
    }

    public void paintFigure(Graphics g, Rectangle rect) {
        int centerX = rect.x + rect.width / 2;
        int centerY = rect.y + rect.height / 2;
        int width = Math.min(rect.width, rect.height);
        int innerWidth = width * 4 / 5;
        int left = centerX - innerWidth / 2;
        int top = centerY - innerWidth / 2;
        BorderUtil.drawBorder(g, left, top, innerWidth, innerWidth, 2, true);
        if (this.isChecked()) {
            g.pushState();
            Display display = Display.getCurrent();
            g.setForegroundColor(display.getSystemColor(2));
            g.drawLine(left + 3, top + 2, left + innerWidth - 3, top + innerWidth - 4);
            g.drawLine(left + 2, top + 2, left + innerWidth - 3, top + innerWidth - 3);
            g.drawLine(left + innerWidth - 4, top + 2, left + 2, top + innerWidth - 4);
            g.drawLine(left + innerWidth - 3, top + 2, left + 2, top + innerWidth - 3);
            g.popState();
        }
    }

    private int getDefaultWidth() {
        return 15;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }
}

