/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.widget;

import java.util.StringTokenizer;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFont;
import org.eclipse.jst.pagedesigner.css2.layout.TextLayoutSupport;
import org.eclipse.jst.pagedesigner.css2.property.ICSSPropertyMeta;
import org.eclipse.jst.pagedesigner.css2.provider.DimensionInfo;
import org.eclipse.jst.pagedesigner.css2.style.DefaultStyle;
import org.eclipse.jst.pagedesigner.css2.widget.AbstractWidgetProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ButtonWidgetProvider
extends AbstractWidgetProvider {
    private static final double HORIZONTAL_RATE = 1.46;
    private static final double VERTICAL_PADDING_RATE = 0.36;
    private static final String[] DEFAULTLINES = new String[]{"  "};
    private String _value = "";
    private String[] _lines = DEFAULTLINES;

    public ButtonWidgetProvider(ICSSStyle style) {
        super(style);
    }

    public DimensionInfo getPreferredDimension(int width, int height) {
        if (width <= 0) {
            width = this.getDefaultWidth();
        }
        if (height <= 0) {
            height = this.getDefaultHeight();
        }
        return new DimensionInfo(new Dimension(width, height), -1);
    }

    public int getDefaultWidth() {
        int longestStringWidth = 0;
        if (this._lines != null) {
            ICSSStyle style = this.getCSSStyle();
            if (style == null) {
                style = DefaultStyle.getInstance();
            }
            ICSSFont font = style.getCSSFont();
            Font swtFont = font.getSwtFont();
            int i = 0;
            while (i < this._lines.length) {
                int width = FigureUtilities.getTextWidth((String)this._lines[i], (Font)swtFont);
                if (width > longestStringWidth) {
                    longestStringWidth = width;
                }
                ++i;
            }
        }
        return (int)((double)longestStringWidth * 1.46);
    }

    public int getDefaultHeight() {
        ICSSStyle style = this.getCSSStyle();
        if (style == null) {
            style = DefaultStyle.getInstance();
        }
        ICSSFont font = style.getCSSFont();
        Font swtfont = font.getSwtFont();
        int fontHeight = FigureUtilities.getFontMetrics((Font)swtfont).getHeight();
        return (int)((double)fontHeight * ((double)this._lines.length + 0.36));
    }

    public void paintFigure(Graphics g, Rectangle rect) {
        Object textAlign;
        ICSSStyle style = this.getCSSStyle();
        if (style == null) {
            style = DefaultStyle.getInstance();
        }
        if (ICSSPropertyMeta.NOT_SPECIFIED == (textAlign = style.getStyleProperty("text-align"))) {
            textAlign = "center";
        }
        Font font = style.getCSSFont().getSwtFont();
        g.setFont(font);
        int fontHeight = FigureUtilities.getFontMetrics((Font)font).getHeight();
        Color newColor = null;
        Object color = style.getColor();
        if (color instanceof Color) {
            g.setForegroundColor((Color)color);
        } else if (color instanceof RGB) {
            newColor = new Color((Device)Display.getCurrent(), (RGB)color);
            g.setForegroundColor(newColor);
        } else {
            g.setForegroundColor(ColorConstants.black);
        }
        g.clipRect(rect);
        int y = rect.y + (int)((double)fontHeight * 0.36 / 2.0);
        if (rect.height > fontHeight * this._lines.length) {
            y = rect.y + (rect.height - fontHeight * this._lines.length) / 2;
        }
        int i = 0;
        while (i < this._lines.length && y < rect.y + rect.height) {
            int width = FigureUtilities.getTextWidth((String)this._lines[i], (Font)font);
            int x = TextLayoutSupport.getBeginX(textAlign, rect, width);
            g.drawString(this._lines[i], x, y);
            TextLayoutSupport.paintTextDecoration(g, new Rectangle(x, y, width, fontHeight), (Integer)this.getCSSStyle().getStyleProperty("text-decoration"));
            y += fontHeight;
            ++i;
        }
        if (newColor != null) {
            newColor.dispose();
        }
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        this._value = value;
        this._lines = this.splitValue(this._value);
    }

    private String[] splitValue(String _value2) {
        if (_value2 == null || "".equals(_value2)) {
            return DEFAULTLINES;
        }
        StringTokenizer tokenizer = new StringTokenizer(_value2, "\r\n");
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokenizer.nextToken().replaceAll("\t", "    ");
            ++i;
        }
        return result;
    }
}

