/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.style;

import java.util.Map;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.font.CSSFontManager;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFont;
import org.eclipse.jst.pagedesigner.css2.list.ICounterValueGenerator;
import org.eclipse.jst.pagedesigner.css2.property.CSSMetaRegistry;
import org.eclipse.jst.pagedesigner.css2.property.ICSSPropertyMeta;
import org.eclipse.jst.pagedesigner.ui.preferences.PDPreferences;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;

public class DefaultStyle
implements ICSSStyle {
    private static final Insets EMPTY_INSETS = new Insets();
    protected static final PDPreferences PREFS = new PDPreferences();
    private final PDPreferences _prefs;
    private ICSSFont defaultFont = CSSFontManager.getInstance().createDefaultFont();
    static DefaultStyle _instance;

    public DefaultStyle(PDPreferences prefs) {
        this._prefs = prefs;
    }

    public void reset() {
    }

    public Object getStyleProperty(String property) {
        ICSSPropertyMeta meta = CSSMetaRegistry.getInstance().getMeta(property);
        if (meta == null) {
            return ICSSPropertyMeta.NOT_SPECIFIED;
        }
        return meta.getInitialValue(property, this);
    }

    public Insets getMarginInsets() {
        return EMPTY_INSETS;
    }

    public Insets getBorderInsets() {
        return EMPTY_INSETS;
    }

    public Insets getPaddingInsets() {
        int offset = this._prefs.getCssArtificialCellPadding();
        return new Insets(offset, offset, offset, offset);
    }

    public boolean isSizeIncludeBorderPadding() {
        return true;
    }

    public void dispose() {
    }

    public boolean isAdapterForType(Object type) {
        return type == ICSSStyle.class;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public ICSSFont getCSSFont() {
        return this.defaultFont;
    }

    public static ICSSStyle getInstance() {
        if (_instance == null) {
            _instance = new DefaultStyle(PREFS);
        }
        return _instance;
    }

    public ICSSStyle getParentStyle() {
        return null;
    }

    public Object getBackgroundColor() {
        return null;
    }

    public Object getColor() {
        return null;
    }

    public String getDisplay() {
        return "inline";
    }

    public Map getCounters() {
        return null;
    }

    public ICounterValueGenerator findCounter(String name, boolean must) {
        return null;
    }

    public int getColSpan() {
        return 1;
    }

    public int getRowSpan() {
        return 1;
    }

    public boolean isInSelection() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void processCounters() {
    }

    public Object getHTMLelementInitValue(String propertyName) {
        ICSSPropertyMeta meta = CSSMetaRegistry.getInstance().getMeta(propertyName);
        if (meta == null) {
            return ICSSPropertyMeta.NOT_SPECIFIED;
        }
        return meta.getInitialValue(propertyName, this);
    }
}

