/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.CopyNodeCommand;
import org.eclipse.jst.pagedesigner.commands.DesignAction;
import org.eclipse.jst.pagedesigner.commands.range.CopyCommand;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;

public class CopyAction
extends DesignAction
implements UpdateAction {
    public CopyAction(GraphicalEditor editor) {
        super(editor, PDPlugin.getResourceString("Action.Name.Copy"));
    }

    public void perform() {
        CopyCommand command = null;
        IHTMLGraphicalViewer viewer = this.getViewer();
        if (viewer.isInRangeMode()) {
            command = new CopyCommand(viewer);
            command.execute();
        } else {
            CopyNodeCommand nodeCopy = new CopyNodeCommand(viewer);
            nodeCopy.execute();
        }
    }

    public boolean isEnabled() {
        IHTMLGraphicalViewer viewer = this.getViewer();
        if (viewer != null) {
            if (viewer.isInRangeMode() && !EditModelQuery.isSame(viewer.getRangeSelection())) {
                return true;
            }
            if (!viewer.isInRangeMode() && viewer.getSelectedEditParts().size() > 0) {
                return true;
            }
        }
        return false;
    }

    public void update() {
        this.setEnabled(this.isEnabled());
    }
}

