/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.symbols;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IBoundedMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.IDTExternalContext;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.jst.jsf.designtime.symbols.DefaultBeanSymbolSourceProvider;
import org.eclipse.jst.jsf.designtime.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.symbols.JSFSymbolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuiltInSymbolProvider {
    private static DefaultBuiltInSymbolProvider INSTANCE;
    private static final JSFSymbolFactory _symbolFactory;
    private static final String APPLICATION_SCOPE = "applicationScope";
    private static final String SESSION_SCOPE = "sessionScope";
    private static final String REQUEST_SCOPE = "requestScope";
    private static final String COOKIE_IMPLICIT_OBJ = "cookie";
    private static final String FACES_CONTEXT_IMPLICIT_OBJ = "facesContext";
    private static final String HEADER_IMPLICIT_OBJ = "header";
    private static final String HEADER_VALUES_IMPLICIT_OBJ = "headerValues";
    private static final String INIT_PARAM_IMPLICIT_OBJ = "initParam";
    private static final String PARAM_IMPLICIT_OBJ = "param";
    private static final String PARAM_VALUES_IMPLICIT_OBJ = "paramValues";
    private static final String VIEW_IMPLICIT_OBJ = "view";
    private static final String FACES_CONTEXT_FULLY_QUALIFIED_CLASS = "javax.faces.context.FacesContext";
    private static final String VIEW_FULLY_QUALIFIED_CLASS = "javax.faces.component.UIViewRoot";
    private static final ISymbol SYMBOL_COOKIE_IMPLICIT_OBJ;
    private static final ISymbol SYMBOL_HEADER_IMPLICIT_OBJ;
    private static final ISymbol SYMBOL_HEADER_VALUES_IMPLICIT_OBJ;
    private static final ISymbol SYMBOL_PARAM_IMPLICIT_OBJ;
    private static final ISymbol SYMBOL_PARAM_VALUES_IMPLICIT_OBJ;
    private static final ISymbol SYMBOL_INIT_PARAM_IMPLICIT_OBJ;
    private static final String VIEW_SCOPE = "viewScope";
    private static final String FLASH_SCOPE = "flash";
    private static final String CC_IMPLICIT_OBJ = "cc";
    private static final String COMPONENT_IMPLICIT_OBJ = "component";
    private static final String RESOURCE_IMPLICIT_OBJ = "resource";
    private static final String UICOMPONENT_FULLY_QUALIFIED_CLASS = "javax.faces.component.UIComponent";

    static {
        _symbolFactory = new JSFSymbolFactory();
        SYMBOL_COOKIE_IMPLICIT_OBJ = _symbolFactory.createUnknownInstanceSymbol(COOKIE_IMPLICIT_OBJ, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        SYMBOL_HEADER_IMPLICIT_OBJ = _symbolFactory.createUnknownInstanceSymbol(HEADER_IMPLICIT_OBJ, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        SYMBOL_HEADER_VALUES_IMPLICIT_OBJ = _symbolFactory.createUnknownInstanceSymbol(HEADER_VALUES_IMPLICIT_OBJ, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        SYMBOL_PARAM_IMPLICIT_OBJ = _symbolFactory.createUnknownInstanceSymbol(PARAM_IMPLICIT_OBJ, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        SYMBOL_PARAM_VALUES_IMPLICIT_OBJ = _symbolFactory.createUnknownInstanceSymbol(PARAM_VALUES_IMPLICIT_OBJ, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        SYMBOL_INIT_PARAM_IMPLICIT_OBJ = _symbolFactory.createUnknownInstanceSymbol(INIT_PARAM_IMPLICIT_OBJ, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
    }

    public static synchronized DefaultBuiltInSymbolProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultBuiltInSymbolProvider();
        }
        return INSTANCE;
    }

    protected DefaultBuiltInSymbolProvider() {
    }

    public ISymbol[] getSymbols(IAdaptable context, int symbolScopeMask) {
        IFile fileContext = FileContextUtil.deriveIFileFromContext(context);
        return this.getSymbolsForScope(fileContext, symbolScopeMask).toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
    }

    public ISymbol getSymbol(String name, IAdaptable context, int symbolScopeMask) {
        IFile file = FileContextUtil.deriveIFileFromContext(context);
        ISymbol symbol = null;
        if ((symbolScopeMask & 1) != 0) {
            symbol = this.getRequestScopeSymbols(file).get(name);
        }
        if ((symbolScopeMask & 2) != 0 && symbol == null) {
            symbol = this.getSessionScopeSymbols(file).get(name);
        }
        if ((symbolScopeMask & 4) != 0 && symbol == null) {
            symbol = this.getApplicationScopeSymbols(file).get(name);
        }
        if ((symbolScopeMask & 0x10) != 0 && symbol == null) {
            symbol = this.getViewScopeSymbols(file).get(name);
        }
        if ((symbolScopeMask & 0x20) != 0 && symbol == null) {
            symbol = this.getFlashScopeSymbols(file).get(name);
        }
        return symbol;
    }

    public ISymbol[] getSymbols(String prefix, IAdaptable context, int symbolScopeMask) {
        IFile file = FileContextUtil.deriveIFileFromContext(context);
        ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
        if ((symbolScopeMask & 1) != 0) {
            symbols.addAll(this.getRequestScopeSymbols(file).values());
        }
        if ((symbolScopeMask & 2) != 0) {
            symbols.addAll(this.getSessionScopeSymbols(file).values());
        }
        if ((symbolScopeMask & 4) != 0) {
            symbols.addAll(this.getApplicationScopeSymbols(file).values());
        }
        if ((symbolScopeMask & 0x10) != 0) {
            symbols.addAll(this.getViewScopeSymbols(file).values());
        }
        if ((symbolScopeMask & 0x20) != 0) {
            symbols.addAll(this.getFlashScopeSymbols(file).values());
        }
        return symbols.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
    }

    private List getSymbolsForScope(IFile file, int symbolScopeMask) {
        ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
        if ((symbolScopeMask & 1) != 0) {
            symbols.addAll(this.getRequestScopeSymbols(file).values());
        }
        if ((symbolScopeMask & 2) != 0) {
            symbols.addAll(this.getSessionScopeSymbols(file).values());
        }
        if ((symbolScopeMask & 4) != 0) {
            symbols.addAll(this.getApplicationScopeSymbols(file).values());
        }
        if ((symbolScopeMask & 0x10) != 0) {
            symbols.addAll(this.getViewScopeSymbols(file).values());
        }
        if ((symbolScopeMask & 0x20) != 0) {
            symbols.addAll(this.getFlashScopeSymbols(file).values());
        }
        return symbols;
    }

    private Map<String, ISymbol> getRequestScopeSymbols(IFile file) {
        HashMap<String, ISymbol> requestSymbols = new HashMap<String, ISymbol>();
        ISymbol symbol = this.createScopeSymbol(file, 1, REQUEST_SCOPE);
        requestSymbols.put(symbol.getName(), symbol);
        requestSymbols.put(SYMBOL_COOKIE_IMPLICIT_OBJ.getName(), SYMBOL_COOKIE_IMPLICIT_OBJ);
        requestSymbols.put(SYMBOL_HEADER_IMPLICIT_OBJ.getName(), SYMBOL_HEADER_IMPLICIT_OBJ);
        requestSymbols.put(SYMBOL_HEADER_VALUES_IMPLICIT_OBJ.getName(), SYMBOL_HEADER_VALUES_IMPLICIT_OBJ);
        requestSymbols.put(SYMBOL_PARAM_IMPLICIT_OBJ.getName(), SYMBOL_PARAM_IMPLICIT_OBJ);
        requestSymbols.put(SYMBOL_PARAM_VALUES_IMPLICIT_OBJ.getName(), SYMBOL_PARAM_VALUES_IMPLICIT_OBJ);
        symbol = _symbolFactory.createBeanOrUnknownInstanceSymbol(file.getProject(), FACES_CONTEXT_FULLY_QUALIFIED_CLASS, FACES_CONTEXT_IMPLICIT_OBJ, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        requestSymbols.put(symbol.getName(), symbol);
        symbol = _symbolFactory.createBeanOrUnknownInstanceSymbol(file.getProject(), VIEW_FULLY_QUALIFIED_CLASS, VIEW_IMPLICIT_OBJ, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        requestSymbols.put(symbol.getName(), symbol);
        if (JSFVersion.guessAtLeast(JSFVersion.V2_0, file.getProject())) {
            symbol = _symbolFactory.createBeanOrUnknownInstanceSymbol(file.getProject(), UICOMPONENT_FULLY_QUALIFIED_CLASS, CC_IMPLICIT_OBJ, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
            requestSymbols.put(symbol.getName(), symbol);
            symbol = _symbolFactory.createBeanOrUnknownInstanceSymbol(file.getProject(), UICOMPONENT_FULLY_QUALIFIED_CLASS, COMPONENT_IMPLICIT_OBJ, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
            requestSymbols.put(symbol.getName(), symbol);
        }
        return Collections.unmodifiableMap(requestSymbols);
    }

    private Map<String, ISymbol> getSessionScopeSymbols(IFile file) {
        ISymbol symbol = this.createScopeSymbol(file, 2, SESSION_SCOPE);
        return Collections.unmodifiableMap(Collections.singletonMap(symbol.getName(), symbol));
    }

    private Map<String, ISymbol> getApplicationScopeSymbols(IFile file) {
        HashMap<String, ISymbol> symbols = new HashMap<String, ISymbol>();
        symbols.put(SYMBOL_INIT_PARAM_IMPLICIT_OBJ.getName(), SYMBOL_INIT_PARAM_IMPLICIT_OBJ);
        ISymbol symbol = this.createScopeSymbol(file, 4, APPLICATION_SCOPE);
        symbols.put(symbol.getName(), symbol);
        if (JSFVersion.guessAtLeast(JSFVersion.V2_0, file.getProject())) {
            symbol = _symbolFactory.createUnknownInstanceSymbol(RESOURCE_IMPLICIT_OBJ, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
            symbols.put(symbol.getName(), symbol);
        }
        return Collections.unmodifiableMap(symbols);
    }

    private Map<String, ISymbol> getViewScopeSymbols(IFile file) {
        if (JSFVersion.guessAtLeast(JSFVersion.V2_0, file.getProject())) {
            ISymbol symbol = this.createScopeSymbol(file, 16, VIEW_SCOPE);
            return Collections.unmodifiableMap(Collections.singletonMap(symbol.getName(), symbol));
        }
        return Collections.emptyMap();
    }

    private Map<String, ISymbol> getFlashScopeSymbols(IFile file) {
        if (JSFVersion.guessAtLeast(JSFVersion.V2_0, file.getProject())) {
            ISymbol symbol = this.createScopeSymbol(file, 32, FLASH_SCOPE);
            return Collections.unmodifiableMap(Collections.singletonMap(symbol.getName(), symbol));
        }
        return Collections.emptyMap();
    }

    private ISymbol createScopeSymbol(IFile file, int scopeMask, String name) {
        ScopeMap mapSource = new ScopeMap(file, scopeMask);
        IBoundedMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIBoundedMapTypeDescriptor();
        typeDesc.setMapSource((Map)mapSource);
        typeDesc.setImmutable(false);
        IInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIInstanceSymbol();
        symbol.setName(name);
        symbol.setRuntimeSource(ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        return symbol;
    }

    private static class ScopeMap
    extends AbstractMap {
        private final IFile _externalContextKey;
        private final int _scopeMask;

        ScopeMap(IFile externalContextKey, int scopeMask) {
            this._externalContextKey = externalContextKey;
            this._scopeMask = scopeMask;
        }

        public Set entrySet() {
            ISymbol[] beanSymbols;
            HashMap<String, ISymbol> scopeMap = new HashMap<String, ISymbol>();
            DefaultBeanSymbolSourceProvider beanProvider = DefaultBeanSymbolSourceProvider.getInstance();
            ISymbol[] iSymbolArray = beanSymbols = beanProvider.getSymbols((IAdaptable)this._externalContextKey, this._scopeMask);
            int n = beanSymbols.length;
            int n2 = 0;
            while (n2 < n) {
                ISymbol beanSymbol = iSymbolArray[n2];
                scopeMap.put(beanSymbol.getName(), beanSymbol);
                ++n2;
            }
            DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(this._externalContextKey.getProject());
            if (manager != null) {
                IDTExternalContext externalContext = manager.getFacesContext(this._externalContextKey).getDTExternalContext((IAdaptable)this._externalContextKey);
                scopeMap.putAll(externalContext.getMapForScope(this._scopeMask));
                DTUIViewRoot viewRoot = manager.getFacesContext(this._externalContextKey).getViewRootHandle().getCachedViewRoot();
                if (viewRoot == null) {
                    viewRoot = manager.getFacesContext(this._externalContextKey).getViewRootHandle().updateViewRoot();
                }
                scopeMap.putAll(viewRoot.getViewMap());
            }
            return scopeMap.entrySet();
        }
    }
}

