/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.finder.acceptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.finder.AbstractMatcher;
import org.eclipse.jst.jsf.common.internal.finder.VisitorMatcher;
import org.eclipse.jst.jsf.common.internal.finder.acceptor.ClasspathEntryJarMatchingAcceptor;
import org.eclipse.jst.jsf.common.internal.resource.ClasspathJarFile;
import org.eclipse.jst.jsf.common.internal.resource.JavaCoreMediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarMatchingAcceptor
extends VisitorMatcher.MatchingAcceptor<IProject, ClasspathJarFile> {
    private final JavaCoreMediator _javaCoreMediator;

    public JarMatchingAcceptor(JavaCoreMediator javaCoreMediator) {
        this._javaCoreMediator = javaCoreMediator;
    }

    @Override
    protected Collection<ClasspathJarFile> getInputChildren(IProject project) {
        IJavaProject javaProject = this._javaCoreMediator.create(project);
        IPackageFragmentRoot[] roots = null;
        try {
            roots = javaProject.getPackageFragmentRoots();
        }
        catch (JavaModelException e1) {
            JSFCommonPlugin.log(e1);
        }
        if (roots == null || roots.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ClasspathJarFile> jars = new ArrayList<ClasspathJarFile>();
        VisitorMatcher<IPackageFragmentRoot, ClasspathJarFile, String> entryMatcher = new VisitorMatcher<IPackageFragmentRoot, ClasspathJarFile, String>("", "", new ClasspathEntryJarMatchingAcceptor(project), (List<AbstractMatcher.IMatcher>)Collections.singletonList(new AbstractMatcher.AlwaysMatcher()));
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            try {
                jars.addAll((Collection<ClasspathJarFile>)entryMatcher.perform((Object)root));
            }
            catch (Exception e) {
                JSFCommonPlugin.log(e);
            }
            ++n2;
        }
        return jars;
    }

    @Override
    protected Collection<ClasspathJarFile> getVisitableChildren(ClasspathJarFile visitType) {
        return Collections.EMPTY_LIST;
    }
}

