/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.internal.actions.OpenJ2EEResourceAction;
import org.eclipse.jst.j2ee.internal.provider.J2EEUtilityJarItemProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class J2EEActionProvider
extends CommonActionProvider {
    private static final Class IRESOURCE_CLASS = IResource.class;
    private OpenJ2EEResourceAction openAction;

    public void init(ICommonActionExtensionSite aConfig) {
        this.openAction = new OpenJ2EEResourceAction();
    }

    public void setContext(ActionContext aContext) {
        if (aContext != null && aContext.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)aContext.getSelection();
            this.openAction.selectionChanged(selection);
            Object[] array = selection.toArray();
            if (this.isUtilityJars(array)) {
                J2EEUtilityJarItemProvider utilityJarItemProvider = null;
                ArrayList newSelection = new ArrayList();
                int i = 0;
                while (i < array.length) {
                    utilityJarItemProvider = (J2EEUtilityJarItemProvider)array[i];
                    newSelection.addAll(utilityJarItemProvider.getChildren(null));
                    ++i;
                }
                StructuredSelection structuredSelection = new StructuredSelection(newSelection);
            }
        }
        super.setContext(aContext);
    }

    public void fillActionBars(IActionBars theActionBars) {
        if (this.openAction.isEnabled()) {
            theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        }
    }

    public void fillContextMenu(IMenuManager aMenu) {
        if (this.getContext() == null || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (!this.adaptsToResource(selection.toArray())) {
            this.openAction.selectionChanged(selection);
            if (this.openAction.isEnabled()) {
                aMenu.insertAfter("group.open", (IAction)this.openAction);
            }
        }
    }

    private boolean adaptsToResource(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IResource) {
                return true;
            }
            if (objects[i] instanceof IAdaptable && ((IAdaptable)objects[i]).getAdapter(IRESOURCE_CLASS) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isUtilityJars(Object[] items) {
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i] == null || items[i].getClass() != J2EEUtilityJarItemProvider.class) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

