/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class CreateJPAEntityFeature
extends AbstractCreateFeature {
    private IPreferenceStore jpaPreferenceStore = JPADiagramEditorPlugin.getDefault().getPreferenceStore();
    private boolean isMappedSuperclassChild;
    private PersistentType mappedSuperclass;
    private String mappedSuperclassName;
    private String mappedSuperclassPackage;
    private boolean superHasPrimarykey;

    public CreateJPAEntityFeature(IFeatureProvider fp) {
        super(fp, JPAEditorMessages.CreateJPAEntityFeature_jpaEntityFeatureName, JPAEditorMessages.CreateJPAEntityFeature_jpaEntityFeatureDescription);
    }

    public CreateJPAEntityFeature(IFeatureProvider fp, boolean isMappedSuperclassChild, String mappedSuperclassName, String mappedSuperClassPackage) {
        this(fp, isMappedSuperclassChild, mappedSuperclassName, mappedSuperClassPackage, false);
    }

    public CreateJPAEntityFeature(IFeatureProvider fp, boolean isMappedSuperclassChild, String mappedSuperclassName) {
        this(fp, isMappedSuperclassChild, mappedSuperclassName, null, false);
    }

    public CreateJPAEntityFeature(IFeatureProvider fp, boolean isMappedSuperclassChild, String mappedSuperclassName, String mappedSuperClassPackage, boolean superHasPrimaryKey) {
        this(fp);
        this.isMappedSuperclassChild = isMappedSuperclassChild;
        this.mappedSuperclassName = mappedSuperclassName;
        this.mappedSuperclassPackage = mappedSuperClassPackage;
        this.superHasPrimarykey = superHasPrimaryKey;
    }

    public CreateJPAEntityFeature(IJPAEditorFeatureProvider fp, PersistentType mappedSuperclass) throws JavaModelException {
        this(fp);
        this.isMappedSuperclassChild = true;
        this.mappedSuperclass = mappedSuperclass;
        this.mappedSuperclassName = mappedSuperclass.getName();
        this.mappedSuperclassPackage = JpaArtifactFactory.instance().getMappedSuperclassPackageDeclaration(mappedSuperclass);
        this.superHasPrimarykey = JpaArtifactFactory.instance().hasOrInheritsPrimaryKey(mappedSuperclass);
    }

    public boolean canCreate(ICreateContext context) {
        return context.getTargetContainer() instanceof Diagram;
    }

    public Object[] create(ICreateContext context) {
        EList shapes = this.getFeatureProvider().getDiagramTypeProvider().getDiagram().getChildren();
        IProject targetProject = null;
        JpaProject jpaProject = null;
        if (shapes == null || shapes.size() == 0) {
            jpaProject = this.getTargetJPAProject();
            targetProject = jpaProject.getProject();
        } else {
            Shape sh = (Shape)shapes.get(0);
            PersistentType jpt = (PersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)sh);
            if (jpt == null) {
                return new Object[0];
            }
            jpaProject = jpt.getJpaProject();
            targetProject = jpaProject.getProject();
        }
        String entityName = this.getFeatureProvider().getJPAEditorUtil().generateUniqueTypeName(jpaProject, JPADiagramPropertyPage.getDefaultPackage(jpaProject.getProject()), ".Entity", this.getFeatureProvider());
        if (!JPAEditorUtil.checkIsSetPersistenceProviderLibrary(jpaProject)) {
            Shell shell = JPADiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            Status status = new Status(4, "org.eclipse.jpt.jpadiagrameditor.ui", JPAEditorMessages.CreateJPAEntityFeature_createEntityErrorStatusMsg);
            ErrorDialog.openError((Shell)shell, (String)JPAEditorMessages.CreateJPAEntityFeature_createEntityErrorMsgTitle, (String)JPAEditorMessages.CreateJPAEntityFeature_createEntityErrorMsg, (IStatus)status);
            return new Object[0];
        }
        if (!JpaPreferences.getDiscoverAnnotatedClasses((IProject)targetProject)) {
            JPAEditorUtil.createRegisterEntityInXMLJob(jpaProject, entityName);
        }
        try {
            if (this.mappedSuperclass != null) {
                this.getFeatureProvider().getJPAEditorUtil().createEntityInProject(targetProject, entityName, this.mappedSuperclass);
            } else {
                this.getFeatureProvider().getJPAEditorUtil().createEntityInProject(targetProject, entityName, this.jpaPreferenceStore, this.isMappedSuperclassChild, this.mappedSuperclassName, this.mappedSuperclassPackage, "id", this.superHasPrimarykey);
            }
        }
        catch (Exception e1) {
            JPADiagramEditorPlugin.logError("Cannot create an entity in the project " + targetProject.getName(), e1);
        }
        try {
            jpaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e1) {
            JPADiagramEditorPlugin.logError("Cannot refresh the project", e1);
        }
        ListIterator lit = jpaProject.getContextRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator();
        PersistenceUnit pu = (PersistenceUnit)lit.next();
        PersistentType jpt = pu.getPersistentType(entityName);
        int cnt = 0;
        while (jpt == null && cnt < 25) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Thread sleep interrupted", e);
            }
            jpt = pu.getPersistentType(entityName);
            ++cnt;
        }
        if (jpt != null) {
            if (JPADiagramPropertyPage.doesSupportOrmXml(targetProject)) {
                JpaArtifactFactory.instance().addPersistentTypeToORMXml(jpaProject, entityName, "entity");
                try {
                    jpt.getResource().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e1) {
                    JPADiagramEditorPlugin.logError("Cannot refresh the project", e1);
                }
            }
            this.addGraphicalRepresentation((IAreaContext)context, jpt);
            IWorkbenchPartSite ws = ((IDiagramContainerUI)this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer()).getSite();
            ICompilationUnit cu = this.getFeatureProvider().getCompilationUnit(jpt);
            this.getFeatureProvider().getJPAEditorUtil().formatCode(cu, (IWorkbenchSite)ws);
            return new Object[]{jpt};
        }
        JPADiagramEditorPlugin.logError("The JPA entity " + entityName + " could not be created", new Exception());
        return new Object[0];
    }

    public String getCreateImageId() {
        return "org.eclipse.jpt.jpadiagrameditor.ui.add_entity";
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    private JpaProject getTargetJPAProject() {
        return this.getFeatureProvider().getMoinIntegrationUtil().getProjectByDiagram(this.getDiagram());
    }
}

