/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class AddPersistentTypeToOrmXmlCommand
implements Command {
    private JpaProject jpaProject;
    private String mapping;
    private String persistentTypeName;

    public AddPersistentTypeToOrmXmlCommand(JpaProject jpaProject, String mapping, String persistentTypeName) {
        this.jpaProject = jpaProject;
        this.persistentTypeName = persistentTypeName;
        this.mapping = mapping;
    }

    public void execute() {
        PersistenceUnit unit = JpaArtifactFactory.instance().getPersistenceUnit(this.jpaProject);
        if (unit.getMappingFileRefsSize() == 0) {
            return;
        }
        String ormFileName = JPADiagramPropertyPage.getOrmXmlFileName(this.jpaProject.getProject());
        for (MappingFileRef mapFile : unit.getMappingFileRefs()) {
            if (!mapFile.getFileName().equals(ormFileName)) continue;
            OrmXml ormXml = (OrmXml)mapFile.getMappingFile();
            if (ormXml == null || ormXml.getRoot() == null) {
                return;
            }
            OrmPersistentType type = ormXml.getRoot().addPersistentType(this.mapping, this.persistentTypeName);
            for (PersistentAttribute pa : type.getDefaultAttributes()) {
                type.addAttributeToXml(type.getAttributeNamed(pa.getName()));
            }
        }
    }
}

