/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.core.internal.utility.ProjectTools;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.jpa.ui.wizards.gen.JptJpaUiWizardsEntityGenMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PromptJPAProjectWizardPage
extends WizardPage {
    protected static String SELECT_PROJECT_PAGE_NAME = "SelectJPAProject";
    protected Table projTable;
    private TableViewer projTableViewer;
    private static int PROJECT_NAME_COLUMN_INDEX = 0;
    private final String helpContextId;

    public PromptJPAProjectWizardPage(String helpContextId) {
        super(SELECT_PROJECT_PAGE_NAME);
        this.setTitle(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_SELECT_JPA_PROJECT);
        this.setMessage(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_SELECT_JPA_PROJECT_MSG);
        this.helpContextId = helpContextId;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 1;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_SELECT_JPA_PROJECT);
        this.projTableViewer = new TableViewer(composite, 268438020);
        this.projTable = this.projTableViewer.getTable();
        GridData gd = new GridData(4, 4, true, true);
        this.projTable.setLayoutData((Object)gd);
        this.projTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromptJPAProjectWizardPage.this.handleJpaProjectSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.projTableViewer = new TableViewer(this.projTable);
        this.projTableViewer.setLabelProvider((IBaseLabelProvider)new ProjectTableLabelProvider());
        this.projTableViewer.setContentProvider((IContentProvider)new ProjectTableContentProvider());
        this.fillJpaProjectList();
        this.setControl((Control)composite);
        this.validate();
    }

    protected void handleJpaProjectSelection() {
        if (this.projTable.getSelectionIndex() != -1) {
            TableItem item = this.projTable.getItem(this.projTable.getSelectionIndex());
            String projName = item.getText(0);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
            JpaProject jpaProj = this.getJpaProject(project);
            this.getWizard().setJpaProject(jpaProj);
            this.validate();
        }
    }

    public GenerateEntitiesFromSchemaWizard getWizard() {
        return (GenerateEntitiesFromSchemaWizard)super.getWizard();
    }

    private void fillJpaProjectList() {
        this.projTableViewer.setInput((Object)this.getSortedJpaProjectsNames());
    }

    private String[] getSortedJpaProjectsNames() {
        return (String[])ArrayTools.sort((Object[])this.getJpaProjectsNames());
    }

    private String[] getJpaProjectsNames() {
        return (String[])ArrayTools.array((Iterable)IterableTools.transform(this.getJpaProjects(), (Transformer)ProjectTools.NAME_TRANSFORMER), (Object[])StringTools.EMPTY_STRING_ARRAY);
    }

    private Iterable<IProject> getJpaProjects() {
        return IterableTools.filter(this.getProjects(), (Predicate)new ProjectIsValidSelection());
    }

    protected boolean projectIsValidSelection(IProject project) {
        return this.getJpaProject(project) != null;
    }

    protected boolean projectIsValidSelection(JpaProject jpaProject) {
        return jpaProject != null;
    }

    private Iterable<IProject> getProjects() {
        return IterableTools.iterable((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
    }

    private JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    protected void validate() {
        if (this.projTable.getSelectionIndex() != -1) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public final void performHelp() {
        WorkbenchTools.displayHelp((String)this.helpContextId);
    }

    protected class ProjectIsValidSelection
    extends PredicateAdapter<IProject> {
        protected ProjectIsValidSelection() {
        }

        public boolean evaluate(IProject project) {
            return PromptJPAProjectWizardPage.this.projectIsValidSelection(project);
        }
    }

    private final class ProjectTableContentProvider
    implements IStructuredContentProvider {
        private ProjectTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (String[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ProjectTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProjectTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return columnIndex == PROJECT_NAME_COLUMN_INDEX ? WorkbenchTools.getSharedImage((String)"IMG_OBJ_PROJECT") : null;
        }

        public String getColumnText(Object element, int columnIndex) {
            assert (element instanceof String);
            String projectName = (String)element;
            if (columnIndex == PROJECT_NAME_COLUMN_INDEX) {
                return projectName;
            }
            return null;
        }
    }
}

