/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.handlers;

import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.ui.internal.handlers.JpaStructureViewHandler;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

public class PersistentTypeMapAsHandler
extends JpaStructureViewHandler
implements IElementUpdater {
    public static final String COMMAND_ID = "org.eclipse.jpt.jpa.ui.persistentTypeMapAs";
    public static final String COMMAND_PARAMETER_ID = "persistentTypeMappingKey";

    @Override
    protected void execute_(Object[] items, Map<String, String> parameters, IWorkbenchWindow window) {
        String mappingKey = parameters.get(COMMAND_PARAMETER_ID);
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            PersistentType type = (PersistentType)item;
            type.setMappingKey(mappingKey);
            ++n2;
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        IEvaluationService es = (IEvaluationService)element.getServiceLocator().getService(IEvaluationService.class);
        IViewPart part = (IViewPart)es.getCurrentState().getVariable("activePart");
        IStructuredSelection selection = (IStructuredSelection)part.getSite().getSelectionProvider().getSelection();
        String commonMappingKey = this.commonMappingKey(selection);
        String handlerMappingKey = (String)parameters.get(COMMAND_PARAMETER_ID);
        if (handlerMappingKey != null) {
            element.setChecked(handlerMappingKey.equals(commonMappingKey));
        }
    }

    protected String commonMappingKey(IStructuredSelection selection) {
        String commonKey = null;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!(obj instanceof PersistentType)) {
                return null;
            }
            PersistentType persistentType = (PersistentType)obj;
            if (commonKey == null) {
                commonKey = persistentType.getMappingKey();
            } else if (!commonKey.equals(persistentType.getMappingKey())) {
                return null;
            }
            ++n2;
        }
        return commonKey;
    }
}

