/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.ddlgen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jpt.common.core.internal.gen.AbstractJptGenerator;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXmlEnumValue;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkDdlGenerationType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLoggingLevel;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkOutputMode;
import org.eclipse.jpt.jpa.eclipselink.core.internal.EclipseLinkJpaPlatformFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public abstract class EclipseLinkAbstractDDLGenerator
extends AbstractJptGenerator {
    public static final String LAUNCH_CONFIG_NAME = "Dali EclipseLink Table Generation";
    public static final String DDL_GEN_PACKAGE_NAME = "org.eclipse.jpt.jpa.eclipselink.core.ddlgen";
    public static final String ECLIPSELINK_DDL_GEN_CLASS = "org.eclipse.jpt.jpa.eclipselink.core.ddlgen.Main";
    public static final String ECLIPSELINK_DDL_GEN_JAR_PREFIX = "org.eclipse.jpt.jpa.eclipselink.core.ddlgen_";
    public static final String BUNDLE_CLASSPATH = "Bundle-ClassPath";
    public static final String PROPERTIES_FILE_NAME = "login.properties";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String NONE = "NONE";
    private static final String DYNAMIC_PROGRAM_ARGUMENT = "-dynamic";
    private final String puName;
    private final JpaProject jpaProject;
    private final EclipseLinkOutputMode outputMode;
    private static final String JAVAX_PERSISTENCE_BUNDLE = "javax.persistence";
    private static final String ORG_ECLIPSE_PERSISTENCE_CORE_BUNDLE = "org.eclipse.persistence.core";
    private static final String ORG_ECLIPSE_PERSISTENCE_ASM_BUNDLE = "org.eclipse.persistence.asm";
    private static final String ORG_ECLIPSE_PERSISTENCE_ANTLR_BUNDLE = "org.eclipse.persistence.antlr";
    private static final String ORG_ECLIPSE_PERSISTENCE_JPA_BUNDLE = "org.eclipse.persistence.jpa";

    protected EclipseLinkAbstractDDLGenerator(String puName, JpaProject jpaProject, EclipseLinkOutputMode outputMode) {
        super(JavaCore.create((IProject)jpaProject.getProject()));
        this.puName = puName;
        this.jpaProject = jpaProject;
        this.outputMode = outputMode;
    }

    protected String getLaunchConfigName() {
        return LAUNCH_CONFIG_NAME;
    }

    protected String getMainType() {
        return ECLIPSELINK_DDL_GEN_CLASS;
    }

    protected String getBootstrapJarPrefix() {
        return ECLIPSELINK_DDL_GEN_JAR_PREFIX;
    }

    protected void preGenerate(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ConnectionProfile cp = this.getConnectionProfile();
        if (cp != null) {
            cp.disconnect();
            sm.worked(1);
        }
        sm.setWorkRemaining(1);
        this.saveLoginProperties();
        sm.worked(1);
    }

    protected void postGenerate(boolean generationSuccessful) {
        super.postGenerate(generationSuccessful);
        this.reconnect();
    }

    protected void specifyProgramArguments() {
        StringBuffer programArguments = new StringBuffer();
        this.appendProgramArguments(programArguments);
        this.getLaunchConfig().setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments.toString());
    }

    protected void appendProgramArguments(StringBuffer programArguments) {
        this.appendPuNameArgument(programArguments);
        this.appendPropertiesFileArgument(programArguments);
        this.appendDebugArgument(programArguments);
        this.appendDynamicArgument(programArguments);
    }

    private void appendPuNameArgument(StringBuffer sb) {
        sb.append(" -pu \"");
        sb.append(this.puName);
        sb.append("\"");
    }

    private void appendPropertiesFileArgument(StringBuffer sb) {
        sb.append(" -p \"");
        sb.append(this.getProjectLocation()).append("/").append(PROPERTIES_FILE_NAME).append("\"");
    }

    protected void appendDynamicArgument(StringBuffer sb) {
        EclipseLinkJpaPlatformFactory.EclipseLinkJpaPlatformVersion jpaVersion = (EclipseLinkJpaPlatformFactory.EclipseLinkJpaPlatformVersion)this.jpaProject.getJpaPlatform().getJpaVersion();
        if (jpaVersion.isCompatibleWithEclipseLinkVersion("2.1")) {
            sb.append(' ').append(DYNAMIC_PROGRAM_ARGUMENT);
        }
    }

    protected List<String> buildClasspath() throws CoreException {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(this.getBootstrapJarClasspathEntry().getMemento());
        classpath.add(this.getDefaultProjectClasspathEntry().getMemento());
        classpath.addAll(this.getPersistenceOsgiBundlesMemento());
        classpath.add(this.getJdbcJarClasspathEntry().getMemento());
        classpath.add(this.getSystemLibraryClasspathEntry().getMemento());
        if (this.metaInfIsNotOnClasspath()) {
            classpath.add(this.getMetaInfClasspathEntry().getMemento());
        }
        return classpath;
    }

    protected void reconnect() {
        ConnectionProfile cp = this.getConnectionProfile();
        if (cp != null) {
            cp.connect();
        }
    }

    private IRuntimeClasspathEntry getJdbcJarClasspathEntry() {
        return EclipseLinkAbstractDDLGenerator.getArchiveClasspathEntry((IPath)this.buildJdbcJarPath());
    }

    private IRuntimeClasspathEntry getBundleClasspathEntry(String bundleId) {
        IPath persistClasspath = this.getBundleClasspath(bundleId);
        IRuntimeClasspathEntry bundleEntry = EclipseLinkAbstractDDLGenerator.getArchiveClasspathEntry((IPath)persistClasspath);
        return bundleEntry;
    }

    private IRuntimeClasspathEntry getMetaInfClasspathEntry() {
        return EclipseLinkAbstractDDLGenerator.getVariableRuntimeClasspathEntry((IPath)this.getMetaInfPath());
    }

    protected void buildConnectionProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.jdbc.bind-parameters", FALSE);
    }

    private void buildLoggingProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.logging.level", EclipseLinkLoggingLevel.fine);
        this.putProperty(properties, "eclipselink.logging.timestamp", FALSE);
        this.putProperty(properties, "eclipselink.logging.thread", FALSE);
        this.putProperty(properties, "eclipselink.logging.session", FALSE);
        this.putProperty(properties, "eclipselink.logging.exceptions", TRUE);
    }

    protected void buildCustomizationProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.orm.throw.exceptions", TRUE);
    }

    protected void putProperty(Properties properties, String key, String value) {
        properties.put(key, value == null ? "" : value);
    }

    protected void putProperty(Properties properties, String key, PersistenceXmlEnumValue value) {
        this.putProperty(properties, key, this.getPropertyStringValueOf(value));
    }

    protected String getPropertyStringValueOf(PersistenceXmlEnumValue value) {
        return value == null ? null : value.getPropertyValue();
    }

    protected void buildAllProperties(Properties properties) {
        this.buildConnectionProperties(properties);
        this.buildConnectionPoolingProperties(properties);
        this.buildLoggingProperties(properties);
        this.buildCustomizationProperties(properties);
        this.buildDDLModeProperties(properties);
        this.buildProjectLocationProperty(properties);
    }

    private void buildProjectLocationProperty(Properties properties) {
        this.putProperty(properties, "eclipselink.application-location", this.getProjectLocation());
    }

    private void buildDDLModeProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.ddl-generation.output-mode", this.outputMode);
        this.putProperty(properties, "eclipselink.ddl-generation", EclipseLinkDdlGenerationType.drop_and_create_tables);
        this.putProperty(properties, "eclipselink.create-ddl-jdbc-file-name", "createDDL.sql");
        this.putProperty(properties, "eclipselink.drop-ddl-jdbc-file-name", "dropDDL.sql");
    }

    private void buildConnectionPoolingProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.jdbc.read-connections.shared", TRUE);
    }

    private void saveLoginProperties() {
        String propertiesFile = String.valueOf(this.getProjectLocation()) + "/" + PROPERTIES_FILE_NAME;
        Properties elProperties = new Properties();
        this.buildAllProperties(elProperties);
        FileOutputStream stream = null;
        try {
            try {
                File file = new File(propertiesFile);
                if (!file.exists() && !file.createNewFile()) {
                    throw new RuntimeException("createNewFile() failed: " + file);
                }
                stream = new FileOutputStream(file);
                elProperties.store(stream, null);
            }
            catch (Exception e) {
                String message = "Error saving: " + propertiesFile;
                throw new RuntimeException(message, e);
            }
        }
        catch (Throwable throwable) {
            this.closeStream(stream);
            throw throwable;
        }
        this.closeStream(stream);
    }

    private void closeStream(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private IPath getMetaInfPath() {
        JptXmlResource persistenceXmlResource = this.jpaProject.getPersistenceXmlResource();
        IPath persistenceXmlPath = persistenceXmlResource.getFile().getLocation();
        return persistenceXmlPath.removeLastSegments(2);
    }

    private boolean metaInfIsNotOnClasspath() {
        JptXmlResource persistenceXmlResource = this.jpaProject.getPersistenceXmlResource();
        return !this.jpaProject.getJavaProject().isOnClasspath((IResource)persistenceXmlResource.getFile());
    }

    private IPath buildJdbcJarPath() {
        return new Path(this.getJpaProjectConnectionDriverJarList());
    }

    private String getJpaProjectConnectionDriverJarList() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp == null ? "" : cp.getDriverJarList();
    }

    protected JpaPlatform getPlatform() {
        return this.jpaProject.getJpaPlatform();
    }

    protected ConnectionProfile getConnectionProfile() {
        return this.jpaProject.getConnectionProfile();
    }

    private Collection<String> getPersistenceOsgiBundlesMemento() throws CoreException {
        HashSet<String> result = new HashSet<String>();
        if (this.javaxPersistenceBundleExists()) {
            result.add(this.getBundleClasspathEntry(JAVAX_PERSISTENCE_BUNDLE).getMemento());
            result.add(this.getBundleClasspathEntry(ORG_ECLIPSE_PERSISTENCE_CORE_BUNDLE).getMemento());
            result.add(this.getBundleClasspathEntry(ORG_ECLIPSE_PERSISTENCE_ASM_BUNDLE).getMemento());
            result.add(this.getBundleClasspathEntry(ORG_ECLIPSE_PERSISTENCE_ANTLR_BUNDLE).getMemento());
            result.add(this.getBundleClasspathEntry(ORG_ECLIPSE_PERSISTENCE_JPA_BUNDLE).getMemento());
        }
        return result;
    }

    private IPath getBundleClasspath(String pluginID) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle == null) {
            throw new RuntimeException(String.valueOf(pluginID) + " cannot be retrieved from the Platform");
        }
        return this.getClassPath(bundle);
    }

    private IPath getClassPath(Bundle bundle) {
        String path = (String)bundle.getHeaders().get(BUNDLE_CLASSPATH);
        if (path == null) {
            path = ".";
        }
        ManifestElement[] elements = null;
        try {
            elements = ManifestElement.parseHeader((String)BUNDLE_CLASSPATH, (String)path);
        }
        catch (BundleException e) {
            throw new RuntimeException("Error parsing bundle header: " + bundle, e);
        }
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                URL url;
                ManifestElement element = elements[i];
                String value = element.getValue();
                if (".".equals(value)) {
                    value = "/";
                }
                if ((url = bundle.getEntry(value)) != null) {
                    try {
                        URL resolvedURL = FileLocator.resolve((URL)url);
                        String filestring = FileLocator.toFileURL((URL)resolvedURL).getFile();
                        if (filestring.startsWith("file:")) {
                            filestring = filestring.substring(filestring.indexOf(58) + 1);
                        }
                        if (filestring.endsWith("!/")) {
                            filestring = filestring.substring(0, filestring.lastIndexOf(33));
                        }
                        File file = new File(filestring);
                        String filePath = file.getCanonicalPath();
                        return new Path(filePath);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error locating bundle: " + bundle, e);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private boolean javaxPersistenceBundleExists() {
        return Platform.getBundle((String)JAVAX_PERSISTENCE_BUNDLE) != null;
    }
}

