/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.refactoring.JptJpaCoreRefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class AbstractJpaMoveJavaElementParticipant
extends MoveParticipant
implements ISharableParticipant {
    protected final Map<IJavaElement, MoveArguments> originalJavaElements = new HashMap<IJavaElement, MoveArguments>();
    protected final Map<IFile, Iterable<ReplaceEdit>> persistenceXmlReplaceEdits = new HashMap<IFile, Iterable<ReplaceEdit>>();
    protected final Map<IFile, Iterable<ReplaceEdit>> mappingFileReplaceEdits = new HashMap<IFile, Iterable<ReplaceEdit>>();

    protected AbstractJpaMoveJavaElementParticipant() {
    }

    protected boolean initialize(Object element) {
        if (!this.getArguments().getUpdateReferences()) {
            return false;
        }
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return true;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        this.originalJavaElements.put((IJavaElement)element, (MoveArguments)arguments);
    }

    protected MoveArguments getArguments(IJavaElement element) {
        return this.originalJavaElements.get(element);
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        monitor.subTask(JptJpaCoreRefactoringMessages.JPA_REFACORING_PARTICIPANT_LOADING_JPA_PROJECTS_SUB_TASK_NAME);
        Iterable<JpaProject> jpaProjects = this.getJpaProjects();
        int size = IterableTools.size(jpaProjects);
        if (size == 0) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(size * 10 + 2));
        sm.subTask(this.getCheckConditionsSubTaskName());
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        for (JpaProject jpaProject : jpaProjects) {
            this.createReplaceEdits((IProgressMonitor)sm.newChild(10), jpaProject);
        }
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IFile file : this.persistenceXmlReplaceEdits.keySet()) {
            deltaFactory.change(file);
        }
        sm.worked(1);
        for (IFile file : this.mappingFileReplaceEdits.keySet()) {
            deltaFactory.change(file);
        }
        sm.worked(1);
        return null;
    }

    protected Iterable<JpaProject> getJpaProjects() throws OperationCanceledException {
        try {
            JpaProjectManager jpaProjectManager = this.getJpaProjectManager();
            return jpaProjectManager != null ? jpaProjectManager.waitToGetJpaProjects() : IterableTools.emptyIterable();
        }
        catch (InterruptedException ex) {
            throw new OperationCanceledException(ex.getMessage());
        }
    }

    protected JpaProjectManager getJpaProjectManager() {
        return (JpaProjectManager)ResourcesPlugin.getWorkspace().getAdapter(JpaProjectManager.class);
    }

    protected abstract String getCompositeChangeName();

    protected abstract String getCheckConditionsSubTaskName();

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.persistenceXmlReplaceEdits.isEmpty() && this.mappingFileReplaceEdits.isEmpty()) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.persistenceXmlReplaceEdits.size() + this.mappingFileReplaceEdits.size()));
        sm.subTask(this.getCreateChangeSubTaskName());
        CompositeChange compositeChange = new CompositeChange(this.getCompositeChangeName());
        for (IFile persistenceXmlFile : this.persistenceXmlReplaceEdits.keySet()) {
            this.addPersistenceXmlRenameEdits(persistenceXmlFile, compositeChange);
            sm.worked(1);
        }
        for (IFile mappingFile : this.mappingFileReplaceEdits.keySet()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addMappingFileRenameEdits(mappingFile, compositeChange);
            sm.worked(1);
        }
        return compositeChange.getChildren().length == 0 ? null : compositeChange;
    }

    protected abstract String getCreateChangeSubTaskName();

    protected void createReplaceEdits(IProgressMonitor monitor, JpaProject jpaProject) throws OperationCanceledException {
        PersistenceUnit persistenceUnit = this.getPersistenceUnit(jpaProject);
        if (persistenceUnit == null) {
            return;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + persistenceUnit.getMappingFileRefsSize()));
        Iterable<ReplaceEdit> classRefDeleteEdits = this.createPersistenceUnitReplaceEditsCheckClasspath(persistenceUnit);
        sm.worked(1);
        if (!IterableTools.isEmpty(classRefDeleteEdits)) {
            this.persistenceXmlReplaceEdits.put(jpaProject.getPersistenceXmlResource().getFile(), classRefDeleteEdits);
        }
        for (MappingFileRef mappingFileRef : persistenceUnit.getMappingFileRefs()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            Iterable<ReplaceEdit> edits = this.createMappingFileReplaceEditsCheckClasspath(mappingFileRef);
            if (!IterableTools.isEmpty(edits)) {
                IFile file = (IFile)mappingFileRef.getMappingFile().getResource();
                this.mappingFileReplaceEdits.put(file, edits);
            }
            sm.worked(1);
        }
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitReplaceEditsCheckClasspath(PersistenceUnit persistenceUnit) {
        return IterableTools.children(this.getElementsOnClasspath(persistenceUnit.getJpaProject()), (Transformer)new PersistenceUnitReplaceEditsTransformer(persistenceUnit));
    }

    protected Iterable<IJavaElement> getElementsOnClasspath(JpaProject jpaProject) {
        IJavaProject javaProject = jpaProject.getJavaProject();
        return IterableTools.filter(this.originalJavaElements.keySet(), (Predicate)new JavaProjectTools.JavaElementIsOnClasspath(javaProject));
    }

    protected abstract Iterable<ReplaceEdit> createPersistenceXmlReplaceEdits(PersistenceUnit var1, IJavaElement var2, Object var3);

    protected void addPersistenceXmlRenameEdits(IFile persistenceXmlFile, CompositeChange compositeChange) {
        Iterable<ReplaceEdit> replacePackageEdits = this.persistenceXmlReplaceEdits.get(persistenceXmlFile);
        TextChange textChange = this.getTextChange(persistenceXmlFile);
        if (textChange == null) {
            textChange = new TextFileChange(this.getPersistenceXmlChangeName(), persistenceXmlFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        this.addEdits(textChange, replacePackageEdits);
    }

    protected abstract String getPersistenceXmlChangeName();

    private Iterable<ReplaceEdit> createMappingFileReplaceEditsCheckClasspath(MappingFileRef mappingFileRef) {
        return IterableTools.children(this.getElementsOnClasspath(mappingFileRef.getJpaProject()), (Transformer)new MappingFileRefReplaceEditsTransformer(mappingFileRef));
    }

    protected abstract Iterable<ReplaceEdit> createMappingFileReplaceEdits(MappingFileRef var1, IJavaElement var2, Object var3);

    protected void addMappingFileRenameEdits(IFile mappingFile, CompositeChange compositeChange) {
        Iterable<ReplaceEdit> replacedTypeEdits = this.mappingFileReplaceEdits.get(mappingFile);
        TextChange textChange = this.getTextChange(mappingFile);
        if (textChange == null) {
            textChange = new TextFileChange(this.getMappingFileChangeName(), mappingFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        this.addEdits(textChange, replacedTypeEdits);
    }

    protected abstract String getMappingFileChangeName();

    private PersistenceUnit getPersistenceUnit(JpaProject jpaProject) {
        PersistenceXml persistenceXml = jpaProject.getContextRoot().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getRoot();
        if (persistence == null) {
            return null;
        }
        if (persistence.getPersistenceUnitsSize() != 1) {
            return null;
        }
        return (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
    }

    private void addEdits(TextChange textChange, Iterable<? extends TextEdit> textEdits) {
        for (TextEdit textEdit : textEdits) {
            try {
                textChange.addEdit(textEdit);
            }
            catch (MalformedTreeException ex) {
                JptJpaCorePlugin.instance().logError(ex);
            }
        }
    }

    class MappingFileRefReplaceEditsTransformer
    extends TransformerAdapter<IJavaElement, Iterable<ReplaceEdit>> {
        private final MappingFileRef mappingFileRef;

        MappingFileRefReplaceEditsTransformer(MappingFileRef mappingFileRef) {
            this.mappingFileRef = mappingFileRef;
        }

        public Iterable<ReplaceEdit> transform(IJavaElement javaElement) {
            return AbstractJpaMoveJavaElementParticipant.this.createMappingFileReplaceEdits(this.mappingFileRef, javaElement, AbstractJpaMoveJavaElementParticipant.this.getArguments(javaElement).getDestination());
        }
    }

    class PersistenceUnitReplaceEditsTransformer
    extends TransformerAdapter<IJavaElement, Iterable<ReplaceEdit>> {
        private final PersistenceUnit persistenceUnit;

        PersistenceUnitReplaceEditsTransformer(PersistenceUnit persistenceUnit) {
            this.persistenceUnit = persistenceUnit;
        }

        public Iterable<ReplaceEdit> transform(IJavaElement javaElement) {
            return AbstractJpaMoveJavaElementParticipant.this.createPersistenceXmlReplaceEdits(this.persistenceUnit, javaElement, AbstractJpaMoveJavaElementParticipant.this.getArguments(javaElement).getDestination());
        }
    }
}

