/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.SpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaUniqueConstraint;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;

public class GenericJavaUniqueConstraint
extends AbstractJavaUniqueConstraint<SpecifiedUniqueConstraint.Parent>
implements JavaSpecifiedUniqueConstraint {
    protected final UniqueConstraintAnnotation uniqueConstraintAnnotation;

    public GenericJavaUniqueConstraint(SpecifiedUniqueConstraint.Parent parent, UniqueConstraintAnnotation uniqueConstraintAnnotation) {
        super(parent);
        this.uniqueConstraintAnnotation = uniqueConstraintAnnotation;
        this.initializeColumnNames();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.syncColumnNames();
    }

    @Override
    public void addColumnName(String columnName) {
        this.addColumnName(this.columnNames.size(), columnName);
    }

    @Override
    public void addColumnName(int index, String columnName) {
        this.uniqueConstraintAnnotation.addColumnName(index, columnName);
        this.addItemToList(index, columnName, this.columnNames, "columnNames");
    }

    @Override
    public void removeColumnName(String columnName) {
        this.removeColumnName(this.columnNames.indexOf(columnName));
    }

    @Override
    public void removeColumnName(int index) {
        this.uniqueConstraintAnnotation.removeColumnName(index);
        this.removeItemFromList(index, this.columnNames, "columnNames");
    }

    @Override
    public void moveColumnName(int targetIndex, int sourceIndex) {
        this.uniqueConstraintAnnotation.moveColumnName(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.columnNames, "columnNames");
    }

    protected void initializeColumnNames() {
        for (String columnName : this.getResourceColumnNames()) {
            this.columnNames.add(columnName);
        }
    }

    @Override
    protected Iterable<String> getResourceColumnNames() {
        return this.uniqueConstraintAnnotation.getColumnNames();
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.columnNamesTouches(pos)) {
            return this.getJavaCandidateColumnNames();
        }
        return null;
    }

    protected boolean columnNamesTouches(int pos) {
        return this.uniqueConstraintAnnotation.columnNamesTouches(pos);
    }

    protected Iterable<String> getJavaCandidateColumnNames() {
        return new TransformationIterable(this.getCandidateColumnNames(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateColumnNames() {
        return ((SpecifiedUniqueConstraint.Parent)this.parent).getCandidateUniqueConstraintColumnNames();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.uniqueConstraintAnnotation.getTextRange();
        return textRange != null ? textRange : ((SpecifiedUniqueConstraint.Parent)this.parent).getValidationTextRange();
    }

    @Override
    public boolean isEquivalentTo(SpecifiedUniqueConstraint uniqueConstraint) {
        return this.columnNamesAreEquivalent(uniqueConstraint);
    }

    protected boolean columnNamesAreEquivalent(SpecifiedUniqueConstraint uniqueConstraint) {
        if (this.getColumnNamesSize() != uniqueConstraint.getColumnNamesSize()) {
            return false;
        }
        int i = 0;
        while (i < this.getColumnNamesSize()) {
            if (ObjectTools.notEquals(this.columnNames.get(i), (Object)uniqueConstraint.getColumnName(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public UniqueConstraintAnnotation getUniqueConstraintAnnotation() {
        return this.uniqueConstraintAnnotation;
    }

    @Override
    public void initializeFrom(UniqueConstraint oldUniqueConstraint) {
        for (String columnName : oldUniqueConstraint.getColumnNames()) {
            this.addColumnName(columnName);
        }
    }
}

