/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTableRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinTableContainer;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationArgumentMessages;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractOrmJoinTableRelationshipStrategy<P extends OrmJoinTableRelationship>
extends AbstractOrmXmlContextModel<P>
implements OrmSpecifiedJoinTableRelationshipStrategy,
OrmSpecifiedJoinTable.ParentAdapter {
    protected OrmSpecifiedJoinTable joinTable;

    protected AbstractOrmJoinTableRelationshipStrategy(P parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        if (this.joinTable != null) {
            this.joinTable.synchronizeWithResourceModel(monitor);
        }
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateJoinTable(monitor);
    }

    @Override
    public OrmSpecifiedJoinTable getJoinTable() {
        return this.joinTable;
    }

    protected void setJoinTable(OrmSpecifiedJoinTable joinTable) {
        OrmSpecifiedJoinTable old = this.joinTable;
        this.joinTable = joinTable;
        this.firePropertyChanged("joinTable", old, joinTable);
    }

    protected void updateJoinTable(IProgressMonitor monitor) {
        if (this.buildsJoinTable()) {
            if (this.joinTable == null) {
                this.setJoinTable(this.buildJoinTable());
            } else {
                this.joinTable.update(monitor);
            }
        } else if (this.joinTable != null) {
            this.setJoinTable(null);
        }
    }

    protected boolean buildsJoinTable() {
        return this.getXmlJoinTable() != null || this.getRelationship().mayHaveDefaultJoinTable();
    }

    protected OrmSpecifiedJoinTable buildJoinTable() {
        return this.getContextModelFactory().buildOrmJoinTable(this);
    }

    @Override
    public XmlJoinTable getXmlJoinTable() {
        return this.getXmlJoinTableContainer().getJoinTable();
    }

    @Override
    public XmlJoinTable buildXmlJoinTable() {
        XmlJoinTable xmlJoinTable = OrmFactory.eINSTANCE.createXmlJoinTable();
        this.getXmlJoinTableContainer().setJoinTable(xmlJoinTable);
        return xmlJoinTable;
    }

    @Override
    public void removeXmlJoinTable() {
        this.getXmlJoinTableContainer().setJoinTable(null);
    }

    protected XmlJoinTableContainer getXmlJoinTableContainer() {
        return this.getRelationship().getXmlContainer();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.joinTable != null) {
            this.joinTable.validate(messages, reporter);
        }
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.joinTable != null) {
            result = this.joinTable.getCompletionProposals(pos);
        }
        return result;
    }

    @Override
    public OrmJoinTableRelationship getRelationship() {
        return (OrmJoinTableRelationship)this.parent;
    }

    protected RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public void initializeFrom(OrmSpecifiedJoinTableRelationshipStrategy oldStrategy) {
        OrmSpecifiedJoinTable oldJoinTable = oldStrategy.getJoinTable();
        if (oldJoinTable != null && oldJoinTable.isSpecifiedInResource()) {
            this.addStrategy();
            this.joinTable.initializeFrom(oldJoinTable);
        }
    }

    @Override
    public void initializeFrom(VirtualJoinTableRelationshipStrategy virtualStrategy) {
        VirtualJoinTable oldTable = virtualStrategy.getJoinTable();
        if (oldTable != null) {
            this.addStrategy();
            this.joinTable.initializeFrom(oldTable);
        }
    }

    @Override
    public String getTableName() {
        return this.joinTable == null ? null : this.joinTable.getName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return this.joinTable == null ? null : this.joinTable.getDbTable();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return ObjectTools.notEquals((Object)this.getTableName(), (Object)tableName);
    }

    @Override
    public String getColumnTableNotValidDescription() {
        return JptJpaCoreValidationArgumentMessages.DOES_NOT_MATCH_JOIN_TABLE;
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this.getRelationship());
    }

    @Override
    public void addStrategy() {
        if (this.joinTable == null) {
            this.setJoinTable(this.buildJoinTable());
            this.buildXmlJoinTable();
        }
    }

    @Override
    public void removeStrategy() {
        if (this.joinTable != null) {
            this.setJoinTable(null);
            this.removeXmlJoinTable();
        }
    }

    @Override
    public OrmSpecifiedJoinTableRelationshipStrategy getTableParent() {
        return this;
    }
}

