/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.TableColumn;
import org.eclipse.jpt.jpa.core.context.VirtualBaseColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedBaseColumn;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmNamedColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlBaseColumn;

public abstract class AbstractOrmBaseColumn<PA extends TableColumn.ParentAdapter, X extends XmlBaseColumn>
extends AbstractOrmNamedColumn<PA, X>
implements OrmSpecifiedBaseColumn {
    protected String specifiedTableName = this.buildSpecifiedTableName();
    protected String defaultTableName;
    protected Boolean specifiedUnique = this.buildSpecifiedUnique();
    protected Boolean specifiedNullable = this.buildSpecifiedNullable();
    protected Boolean specifiedInsertable = this.buildSpecifiedInsertable();
    protected Boolean specifiedUpdatable = this.buildSpecifiedUpdatable();

    protected AbstractOrmBaseColumn(PA parentAdapter) {
        this(parentAdapter, null);
    }

    protected AbstractOrmBaseColumn(PA parentAdapter, X xmlColumn) {
        super(parentAdapter, xmlColumn);
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setSpecifiedTableName_(this.buildSpecifiedTableName());
        this.setSpecifiedUnique_(this.buildSpecifiedUnique());
        this.setSpecifiedNullable_(this.buildSpecifiedNullable());
        this.setSpecifiedInsertable_(this.buildSpecifiedInsertable());
        this.setSpecifiedUpdatable_(this.buildSpecifiedUpdatable());
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setDefaultTableName(this.buildDefaultTableName());
    }

    @Override
    public String getTableName() {
        return this.specifiedTableName != null ? this.specifiedTableName : this.defaultTableName;
    }

    @Override
    public String getSpecifiedTableName() {
        return this.specifiedTableName;
    }

    @Override
    public void setSpecifiedTableName(String tableName) {
        if (ObjectTools.notEquals((Object)this.specifiedTableName, (Object)tableName)) {
            XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedTableName_(tableName);
            xmlColumn.setTable(tableName);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedTableName_(String tableName) {
        String old = this.specifiedTableName;
        this.specifiedTableName = tableName;
        this.firePropertyChanged("specifiedTableName", old, tableName);
    }

    protected String buildSpecifiedTableName() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getTable();
    }

    @Override
    public String getDefaultTableName() {
        return this.defaultTableName;
    }

    protected void setDefaultTableName(String tableName) {
        String old = this.defaultTableName;
        this.defaultTableName = tableName;
        this.firePropertyChanged("defaultTable", old, tableName);
    }

    protected String buildDefaultTableName() {
        return ((TableColumn.ParentAdapter)this.parentAdapter).getDefaultTableName();
    }

    @Override
    public boolean isUnique() {
        return this.specifiedUnique != null ? this.specifiedUnique.booleanValue() : this.isDefaultUnique();
    }

    @Override
    public Boolean getSpecifiedUnique() {
        return this.specifiedUnique;
    }

    @Override
    public void setSpecifiedUnique(Boolean unique) {
        if (ObjectTools.notEquals((Object)this.specifiedUnique, (Object)unique)) {
            XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedUnique_(unique);
            xmlColumn.setUnique(unique);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedUnique_(Boolean unique) {
        Boolean old = this.specifiedUnique;
        this.specifiedUnique = unique;
        this.firePropertyChanged("specifiedUnique", old, unique);
    }

    protected Boolean buildSpecifiedUnique() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getUnique();
    }

    @Override
    public boolean isDefaultUnique() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return this.specifiedNullable != null ? this.specifiedNullable.booleanValue() : this.isDefaultNullable();
    }

    @Override
    public Boolean getSpecifiedNullable() {
        return this.specifiedNullable;
    }

    @Override
    public void setSpecifiedNullable(Boolean nullable) {
        if (ObjectTools.notEquals((Object)this.specifiedNullable, (Object)nullable)) {
            XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedNullable_(nullable);
            xmlColumn.setNullable(nullable);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedNullable_(Boolean nullable) {
        Boolean old = this.specifiedNullable;
        this.specifiedNullable = nullable;
        this.firePropertyChanged("specifiedNullable", old, nullable);
    }

    protected Boolean buildSpecifiedNullable() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getNullable();
    }

    @Override
    public boolean isDefaultNullable() {
        return true;
    }

    @Override
    public boolean isInsertable() {
        return this.specifiedInsertable != null ? this.specifiedInsertable.booleanValue() : this.isDefaultInsertable();
    }

    @Override
    public Boolean getSpecifiedInsertable() {
        return this.specifiedInsertable;
    }

    @Override
    public void setSpecifiedInsertable(Boolean insertable) {
        if (ObjectTools.notEquals((Object)this.specifiedInsertable, (Object)insertable)) {
            XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedInsertable_(insertable);
            xmlColumn.setInsertable(insertable);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedInsertable_(Boolean insertable) {
        Boolean old = this.specifiedInsertable;
        this.specifiedInsertable = insertable;
        this.firePropertyChanged("specifiedInsertable", old, insertable);
    }

    protected Boolean buildSpecifiedInsertable() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getInsertable();
    }

    @Override
    public boolean isDefaultInsertable() {
        return true;
    }

    @Override
    public boolean isUpdatable() {
        return this.specifiedUpdatable != null ? this.specifiedUpdatable.booleanValue() : this.isDefaultUpdatable();
    }

    @Override
    public Boolean getSpecifiedUpdatable() {
        return this.specifiedUpdatable;
    }

    @Override
    public void setSpecifiedUpdatable(Boolean updatable) {
        if (ObjectTools.notEquals((Object)this.specifiedUpdatable, (Object)updatable)) {
            XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedUpdatable_(updatable);
            xmlColumn.setUpdatable(updatable);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedUpdatable_(Boolean updatable) {
        Boolean old = this.specifiedUpdatable;
        this.specifiedUpdatable = updatable;
        this.firePropertyChanged("specifiedUpdatable", old, updatable);
    }

    protected Boolean buildSpecifiedUpdatable() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getUpdatable();
    }

    @Override
    public boolean isDefaultUpdatable() {
        return true;
    }

    protected void initializeFrom(OrmSpecifiedBaseColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedTableName(oldColumn.getSpecifiedTableName());
        this.setSpecifiedUnique(oldColumn.getSpecifiedUnique());
        this.setSpecifiedNullable(oldColumn.getSpecifiedNullable());
        this.setSpecifiedInsertable(oldColumn.getSpecifiedInsertable());
        this.setSpecifiedUpdatable(oldColumn.getSpecifiedUpdatable());
    }

    protected void initializeFrom(VirtualBaseColumn virtualColumn) {
        super.initializeFrom(virtualColumn);
        this.setSpecifiedTableName(virtualColumn.getTableName());
    }

    @Override
    public boolean tableNameIsInvalid() {
        return ((TableColumn.ParentAdapter)this.parentAdapter).tableNameIsInvalid(this.getTableName());
    }

    @Override
    public Iterable<String> getCandidateTableNames() {
        return ((TableColumn.ParentAdapter)this.parentAdapter).getCandidateTableNames();
    }

    @Override
    public TextRange getTableNameValidationTextRange() {
        return this.getValidationTextRange(this.getXmlColumnTableTextRange());
    }

    protected TextRange getXmlColumnTableTextRange() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getTableTextRange();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.tableTouches(pos)) {
            return this.getCandidateTableNames();
        }
        return null;
    }

    protected boolean tableTouches(int pos) {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn != null && xmlColumn.tableTouches(pos);
    }
}

