/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlAdaptableMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElement;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaElementQName;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractQNameAnnotationProxy;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaXmlElement
extends AbstractJavaContextNode
implements XmlElement {
    protected final Context context;
    protected final JaxbQName qName;
    protected Boolean specifiedNillable;
    protected boolean defaultNillable;
    protected Boolean specifiedRequired;
    protected String defaultValue;
    protected String specifiedType;
    protected String defaultType;

    public GenericJavaXmlElement(JaxbContextNode parent, Context context) {
        super(parent);
        this.context = context;
        this.qName = this.buildQName();
        this.specifiedNillable = this.buildSpecifiedNillable();
        this.defaultNillable = this.buildDefaultNillable();
        this.specifiedRequired = this.buildSpecifiedRequired();
        this.defaultValue = this.buildDefaultValue();
        this.specifiedType = this.buildSpecifiedType();
        this.defaultType = this.buildDefaultType();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.qName.synchronizeWithResourceModel();
        this.setSpecifiedNillable_(this.buildSpecifiedNillable());
        this.setDefaultNillable_(this.buildDefaultNillable());
        this.setSpecifiedRequired_(this.buildSpecifiedRequired());
        this.setDefaultValue_(this.buildDefaultValue());
        this.setSpecifiedType_(this.buildSpecifiedType());
        this.setDefaultType_(this.buildDefaultType());
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
    }

    protected Context getContext() {
        return this.context;
    }

    protected JaxbAttributeMapping getAttributeMapping() {
        return this.getContext().getAttributeMapping();
    }

    protected JavaPersistentAttribute getPersistentAttribute() {
        return this.getContext().getAttributeMapping().getPersistentAttribute();
    }

    protected JaxbClassMapping getClassMapping() {
        return this.getPersistentAttribute().getClassMapping();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getClassMapping().getJaxbPackage();
    }

    @Override
    public XmlElementAnnotation getAnnotation(boolean createIfNull) {
        return this.context.getAnnotation(createIfNull);
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    protected JaxbQName buildQName() {
        return new XmlElementQName(this);
    }

    @Override
    public boolean isNillable() {
        return this.specifiedNillable == null ? this.isDefaultNillable() : this.getSpecifiedNillable().booleanValue();
    }

    @Override
    public Boolean getSpecifiedNillable() {
        return this.specifiedNillable;
    }

    @Override
    public void setSpecifiedNillable(Boolean newSpecifiedNillable) {
        this.getAnnotation(true).setNillable(newSpecifiedNillable);
        this.setSpecifiedNillable_(newSpecifiedNillable);
    }

    protected void setSpecifiedNillable_(Boolean newSpecifiedNillable) {
        Boolean oldNillable = this.specifiedNillable;
        this.specifiedNillable = newSpecifiedNillable;
        this.firePropertyChanged("specifiedNillable", oldNillable, newSpecifiedNillable);
    }

    protected Boolean buildSpecifiedNillable() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? null : annotation.getNillable();
    }

    @Override
    public boolean isDefaultNillable() {
        return this.defaultNillable;
    }

    protected void setDefaultNillable_(boolean newNillable) {
        boolean oldNillable = this.defaultNillable;
        this.defaultNillable = newNillable;
        this.firePropertyChanged("defaultNillable", oldNillable, newNillable);
    }

    protected boolean buildDefaultNillable() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? this.getPersistentAttribute().isJavaResourceAttributeCollectionType() : false;
    }

    @Override
    public boolean isRequired() {
        return this.specifiedRequired == null ? this.isDefaultRequired() : this.specifiedRequired.booleanValue();
    }

    @Override
    public Boolean getSpecifiedRequired() {
        return this.specifiedRequired;
    }

    @Override
    public void setSpecifiedRequired(Boolean newSpecifiedRequired) {
        this.getAnnotation(true).setRequired(newSpecifiedRequired);
        this.setSpecifiedRequired_(newSpecifiedRequired);
    }

    protected void setSpecifiedRequired_(Boolean newSpecifiedRequired) {
        Boolean oldRequired = this.specifiedRequired;
        this.specifiedRequired = newSpecifiedRequired;
        this.firePropertyChanged("specifiedRequired", oldRequired, newSpecifiedRequired);
    }

    protected Boolean buildSpecifiedRequired() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? null : annotation.getRequired();
    }

    @Override
    public boolean isDefaultRequired() {
        return false;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.getAnnotation(true).setDefaultValue(defaultValue);
        this.setDefaultValue_(defaultValue);
    }

    protected void setDefaultValue_(String defaultValue) {
        String oldDefaultValue = this.defaultValue;
        this.defaultValue = defaultValue;
        this.firePropertyChanged("defaultValue", oldDefaultValue, defaultValue);
    }

    protected String buildDefaultValue() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? null : annotation.getDefaultValue();
    }

    @Override
    public String getType() {
        return this.specifiedType == null ? this.getDefaultType() : this.specifiedType;
    }

    @Override
    public String getSpecifiedType() {
        return this.specifiedType;
    }

    @Override
    public void setSpecifiedType(String newSpecifiedType) {
        this.getAnnotation(true).setType(newSpecifiedType);
        this.setSpecifiedType_(newSpecifiedType);
    }

    protected void setSpecifiedType_(String newSpecifiedType) {
        String oldType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedType", oldType, newSpecifiedType);
    }

    protected String buildSpecifiedType() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? null : annotation.getType();
    }

    @Override
    public String getDefaultType() {
        return this.defaultType;
    }

    protected void setDefaultType_(String newType) {
        String oldType = this.defaultType;
        this.defaultType = newType;
        this.firePropertyChanged("defaultType", oldType, newType);
    }

    protected String buildDefaultType() {
        return this.context.getDefaultType();
    }

    @Override
    public String getFullyQualifiedType() {
        return this.specifiedType == null ? this.getDefaultType() : this.getAnnotation(false).getFullyQualifiedTypeName();
    }

    @Override
    public Iterable<String> getReferencedXmlTypeNames() {
        return this.specifiedType == null ? EmptyIterable.instance() : new SingleElementIterable((Object)this.getFullyQualifiedType());
    }

    @Override
    public XsdElementDeclaration getXsdElement() {
        XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
        return xsdType == null ? null : xsdType.getElement(this.qName.getNamespace(), this.qName.getName());
    }

    public XsdTypeDefinition getTypeXsdTypeDefinition() {
        JaxbTypeMapping jaxbTypeMapping;
        JaxbPackageInfo pkgInfo;
        String type = this.getFullyQualifiedType();
        if (StringTools.isBlank((String)type) || "defaultType".equals(type)) {
            return null;
        }
        JaxbPackage pkg = this.getJaxbPackage();
        JaxbPackageInfo jaxbPackageInfo = pkgInfo = pkg == null ? null : pkg.getPackageInfo();
        if (pkgInfo != null) {
            for (XmlSchemaType schemaType : pkgInfo.getXmlSchemaTypes()) {
                if (!type.equals(schemaType.getFullyQualifiedType())) continue;
                return schemaType.getXsdTypeDefinition();
            }
        }
        if ((jaxbTypeMapping = this.getContextRoot().getTypeMapping(type)) != null) {
            return jaxbTypeMapping.getXsdTypeDefinition();
        }
        String builtInType = this.getJaxbProject().getPlatform().getDefinition().getSchemaTypeMapping(type);
        if (builtInType != null) {
            return XsdUtil.getSchemaForSchema().getTypeDefinition(builtInType);
        }
        return null;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        result = this.qName.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? this.getParent().getValidationTextRange() : annotation.getTextRange();
    }

    @Override
    public TextRange getTypeTextRange() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? this.getParent().getValidationTextRange() : annotation.getTypeTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateQName(messages, reporter);
        this.validateType(messages, reporter);
        this.validateSchemaType(messages, reporter);
    }

    protected void validateQName(List<IMessage> messages, IReporter reporter) {
        this.qName.validate(messages, reporter);
    }

    protected void validateType(List<IMessage> messages, IReporter reporter) {
        String fqType = this.getFullyQualifiedType();
        if (StringTools.isBlank((String)fqType)) {
            messages.add(this.buildValidationMessage(this.getTypeTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT__UNSPECIFIED_TYPE));
        } else {
            String attributeBaseType;
            XmlAdaptableMapping mapping = (XmlAdaptableMapping)((Object)this.getAttributeMapping());
            if (mapping.getXmlJavaTypeAdapter() != null && mapping.getXmlAdapter() == null) {
                return;
            }
            if (!(StringTools.isBlank((String)this.specifiedType) || JavaProjectTools.findType((IJavaProject)this.getJaxbProject().getJavaProject(), (String)fqType) == null || StringTools.isBlank((String)(attributeBaseType = this.getAttributeMapping().getValueTypeName())) || TypeTools.isSubTypeOf((String)fqType, (String)attributeBaseType, (IJavaProject)this.getJaxbProject().getJavaProject()))) {
                messages.add(this.buildValidationMessage(this.getTypeTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT__ILLEGAL_TYPE, attributeBaseType));
            }
        }
    }

    protected void validateSchemaType(List<IMessage> messages, IReporter reporter) {
        XsdElementDeclaration xsdElement = this.getXsdElement();
        if (xsdElement == null) {
            return;
        }
        XsdTypeDefinition expectedSchemaType = null;
        String typeName = this.context.getAttributeMapping().getDataTypeName();
        if (!"defaultType".equals(this.getFullyQualifiedType())) {
            typeName = this.getFullyQualifiedType();
        }
        if ((expectedSchemaType = this.context.hasXmlID() ? XsdUtil.getSchemaForSchema().getTypeDefinition("ID") : (this.context.hasXmlIDREF() ? XsdUtil.getSchemaForSchema().getTypeDefinition("IDREF") : (this.context.hasXmlSchemaType() ? this.context.getXmlSchemaType().getXsdTypeDefinition() : (!"defaultType".equals(this.getFullyQualifiedType()) ? this.getTypeXsdTypeDefinition() : this.context.getAttributeMapping().getDataTypeXsdTypeDefinition())))) == null) {
            return;
        }
        if (!xsdElement.typeIsValid(expectedSchemaType, this.context.hasXmlList())) {
            messages.add(this.buildValidationMessage(this.qName.getNameValidationTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT__INVALID_SCHEMA_TYPE, typeName, xsdElement.getName()));
        }
    }

    public static interface Context {
        public JavaAttributeMapping getAttributeMapping();

        public XmlElementAnnotation getAnnotation(boolean var1);

        public String getDefaultType();

        public XmlElementWrapper getElementWrapper();

        public boolean hasXmlID();

        public boolean hasXmlIDREF();

        public boolean hasXmlList();

        public boolean hasXmlSchemaType();

        public XmlSchemaType getXmlSchemaType();
    }

    protected class QNameAnnotationProxy
    extends AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        @Override
        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return GenericJavaXmlElement.this.getAnnotation(createIfNull);
        }
    }

    protected class XmlElementQName
    extends AbstractJavaElementQName {
        protected XmlElementQName(JaxbContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JavaPersistentAttribute getPersistentAttribute() {
            return GenericJavaXmlElement.this.getPersistentAttribute();
        }

        @Override
        protected XmlElementWrapper getElementWrapper() {
            return GenericJavaXmlElement.this.context.getElementWrapper();
        }
    }
}

