/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.stack;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EmptyStackException;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.stack.Stack;

public class ArrayStack<E>
implements Stack<E>,
Cloneable,
Serializable {
    private transient E[] elements;
    private int size = 0;
    private static final long serialVersionUID = 1L;

    public ArrayStack() {
        this(10);
    }

    public ArrayStack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal capacity: " + initialCapacity);
        }
        this.elements = new Object[initialCapacity];
    }

    @Override
    public void push(E element) {
        this.ensureCapacity(this.size + 1);
        this.elements[this.size++] = element;
    }

    public void ensureCapacity(int minCapacity) {
        if (this.elements.length < minCapacity) {
            int newCapacity = (this.elements.length * 3 >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elements = this.copyElements(newCapacity);
        }
    }

    public void trimToSize() {
        if (this.elements.length > this.size) {
            this.elements = this.copyElements(this.size);
        }
    }

    private E[] copyElements(int newCapacity) {
        Object[] newElements = new Object[newCapacity];
        if (this.size != 0) {
            System.arraycopy(this.elements, 0, newElements, 0, this.size);
        }
        return newElements;
    }

    @Override
    public E pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        int index = this.size - 1;
        E element = this.elements[index];
        this.elements[index] = null;
        --this.size;
        return element;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.elements[this.size - 1];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public ArrayStack<E> clone() {
        try {
            ArrayStack clone = (ArrayStack)super.clone();
            Object[] array = (Object[])this.elements.clone();
            clone.elements = array;
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return Arrays.toString(ArrayTools.reverse(this.copyElements(this.size)));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        E[] array = this.elements;
        int elementsLength = array.length;
        stream.writeInt(elementsLength);
        int i = 0;
        while (i < this.size) {
            stream.writeObject(array[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int elementsLength = stream.readInt();
        Object[] array = new Object[elementsLength];
        int i = 0;
        while (i < this.size) {
            array[i] = stream.readObject();
            ++i;
        }
        this.elements = array;
    }
}

