/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SingleElementListIterator;
import org.eclipse.jpt.common.utility.internal.model.value.AbstractListValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

public class PropertyListValueModelAdapter<E>
extends AbstractListValueModel
implements ListValueModel<E> {
    protected final PropertyValueModel<? extends E> valueHolder;
    protected final PropertyChangeListener propertyChangeListener;
    protected E value;

    public PropertyListValueModelAdapter(PropertyValueModel<? extends E> valueHolder) {
        if (valueHolder == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
        this.propertyChangeListener = this.buildPropertyChangeListener();
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent event) {
                Object eventNewValue = event.getNewValue();
                PropertyListValueModelAdapter.this.valueChanged(eventNewValue);
            }

            public String toString() {
                return "property change listener";
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.value == null ? EmptyListIterator.instance() : new SingleElementListIterator<E>(this.value);
    }

    @Override
    public int size() {
        return this.value == null ? 0 : 1;
    }

    @Override
    public E get(int index) {
        if (this.value == null) {
            throw this.buildIOOBE(index, 0);
        }
        if (index > 0) {
            throw this.buildIOOBE(index, 1);
        }
        return this.value;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        if (this.value == null) {
            objectArray = ObjectTools.EMPTY_OBJECT_ARRAY;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.value;
        }
        return objectArray;
    }

    protected IndexOutOfBoundsException buildIOOBE(int index, int size) {
        return new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
    }

    @Override
    protected void engageModel() {
        this.valueHolder.addPropertyChangeListener("value", this.propertyChangeListener);
        this.value = this.valueHolder.getValue();
    }

    @Override
    protected void disengageModel() {
        this.valueHolder.removePropertyChangeListener("value", this.propertyChangeListener);
        this.value = null;
    }

    protected void valueChanged(E newValue) {
        E oldValue = this.value;
        this.value = newValue;
        if (oldValue == null) {
            this.fireItemAdded("list values", 0, newValue);
        } else if (newValue == null) {
            this.fireItemRemoved("list values", 0, oldValue);
        } else {
            this.fireItemReplaced("list values", 0, newValue, oldValue);
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        StringBuilderTools.append(sb, this);
    }
}

