/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt;

import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;

public class DateTimeModelAdapter {
    protected final ModifiablePropertyValueModel<Integer> hoursHolder;
    protected final ModifiablePropertyValueModel<Integer> minutesHolder;
    protected final ModifiablePropertyValueModel<Integer> secondsHolder;
    protected final PropertyChangeListener hoursPropertyChangeListener;
    protected final PropertyChangeListener minutesPropertyChangeListener;
    protected final PropertyChangeListener secondsPropertyChangeListener;
    protected final DateTime dateTime;
    protected final SelectionListener dateTimeSelectionListener;
    protected final DisposeListener dateTimeDisposeListener;
    private boolean locked;

    public static DateTimeModelAdapter adapt(ModifiablePropertyValueModel<Integer> hoursHolder, ModifiablePropertyValueModel<Integer> minutesHolder, ModifiablePropertyValueModel<Integer> secondsHolder, DateTime dateTime) {
        return new DateTimeModelAdapter(hoursHolder, minutesHolder, secondsHolder, dateTime);
    }

    protected DateTimeModelAdapter(ModifiablePropertyValueModel<Integer> hoursHolder, ModifiablePropertyValueModel<Integer> minutesHolder, ModifiablePropertyValueModel<Integer> secondsHolder, DateTime dateTime) {
        if (hoursHolder == null || minutesHolder == null || secondsHolder == null || dateTime == null) {
            throw new NullPointerException();
        }
        this.hoursHolder = hoursHolder;
        this.minutesHolder = minutesHolder;
        this.secondsHolder = secondsHolder;
        this.dateTime = dateTime;
        this.hoursPropertyChangeListener = this.buildHoursPropertyChangeListener();
        this.hoursHolder.addPropertyChangeListener("value", this.hoursPropertyChangeListener);
        this.minutesPropertyChangeListener = this.buildMinutesPropertyChangeListener();
        this.minutesHolder.addPropertyChangeListener("value", this.minutesPropertyChangeListener);
        this.secondsPropertyChangeListener = this.buildSecondsPropertyChangeListener();
        this.secondsHolder.addPropertyChangeListener("value", this.secondsPropertyChangeListener);
        this.dateTimeSelectionListener = this.buildDateTimeSelectionListener();
        this.dateTime.addSelectionListener(this.dateTimeSelectionListener);
        this.dateTimeDisposeListener = this.buildDateTimeDisposeListener();
        this.dateTime.addDisposeListener(this.dateTimeDisposeListener);
        this.updateDateTimeHours((Integer)hoursHolder.getValue());
        this.updateDateTimeMinutes((Integer)minutesHolder.getValue());
        this.updateDateTimeSeconds((Integer)secondsHolder.getValue());
    }

    protected PropertyChangeListener buildHoursPropertyChangeListener() {
        return SWTListenerTools.wrap(this.buildHoursPropertyChangeListener_(), (Widget)this.dateTime);
    }

    protected PropertyChangeListener buildHoursPropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                DateTimeModelAdapter.this.hoursChanged(event);
            }

            public String toString() {
                return "dateTime hours listener";
            }
        };
    }

    protected PropertyChangeListener buildMinutesPropertyChangeListener() {
        return SWTListenerTools.wrap(this.buildMinutesPropertyChangeListener_(), (Widget)this.dateTime);
    }

    protected PropertyChangeListener buildMinutesPropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                DateTimeModelAdapter.this.minutesChanged(event);
            }

            public String toString() {
                return "dateTime minutes listener";
            }
        };
    }

    protected PropertyChangeListener buildSecondsPropertyChangeListener() {
        return SWTListenerTools.wrap(this.buildSecondsPropertyChangeListener_(), (Widget)this.dateTime);
    }

    protected PropertyChangeListener buildSecondsPropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                DateTimeModelAdapter.this.secondsChanged(event);
            }

            public String toString() {
                return "dateTime seconds listener";
            }
        };
    }

    protected SelectionListener buildDateTimeSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeModelAdapter.this.dateTimeSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public String toString() {
                return "dateTime selection listener";
            }
        };
    }

    protected DisposeListener buildDateTimeDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                DateTimeModelAdapter.this.dateTimeDisposed(event);
            }

            public String toString() {
                return "dateTime dispose listener";
            }
        };
    }

    protected void hoursChanged(PropertyChangeEvent event) {
        if (!this.locked) {
            this.updateDateTimeHours((Integer)event.getNewValue());
        }
    }

    protected void minutesChanged(PropertyChangeEvent event) {
        if (!this.locked) {
            this.updateDateTimeMinutes((Integer)event.getNewValue());
        }
    }

    protected void secondsChanged(PropertyChangeEvent event) {
        if (!this.locked) {
            this.updateDateTimeSeconds((Integer)event.getNewValue());
        }
    }

    protected void dateTimeSelected(SelectionEvent event) {
        if (!this.locked) {
            this.locked = true;
            try {
                this.hoursSelected();
                this.minutesSelected();
                this.secondsSelected();
            }
            finally {
                this.locked = false;
            }
        }
    }

    protected void hoursSelected() {
        Integer hours = null;
        if (this.dateTime.getHours() != 0) {
            hours = this.dateTime.getHours();
        }
        this.hoursHolder.setValue(hours);
    }

    protected void minutesSelected() {
        Integer minutes = null;
        if (this.dateTime.getMinutes() != 0) {
            minutes = this.dateTime.getMinutes();
        }
        this.minutesHolder.setValue(minutes);
    }

    protected void secondsSelected() {
        Integer seconds = null;
        if (this.dateTime.getSeconds() != 0) {
            seconds = this.dateTime.getSeconds();
        }
        this.secondsHolder.setValue(seconds);
    }

    protected void dateTimeDisposed(DisposeEvent event) {
        this.dateTime.removeDisposeListener(this.dateTimeDisposeListener);
        this.dateTime.removeSelectionListener(this.dateTimeSelectionListener);
        this.hoursHolder.removePropertyChangeListener("value", this.hoursPropertyChangeListener);
        this.minutesHolder.removePropertyChangeListener("value", this.minutesPropertyChangeListener);
        this.secondsHolder.removePropertyChangeListener("value", this.secondsPropertyChangeListener);
    }

    protected void updateDateTimeHours(Integer hours) {
        if (this.dateTime.isDisposed()) {
            return;
        }
        if (hours == null) {
            hours = 0;
        }
        this.locked = true;
        try {
            this.dateTime.setHours(hours.intValue());
        }
        finally {
            this.locked = false;
        }
    }

    protected void updateDateTimeMinutes(Integer minutes) {
        if (this.dateTime.isDisposed()) {
            return;
        }
        if (minutes == null) {
            minutes = 0;
        }
        this.locked = true;
        try {
            this.dateTime.setMinutes(minutes.intValue());
        }
        finally {
            this.locked = false;
        }
    }

    protected void updateDateTimeSeconds(Integer seconds) {
        if (this.dateTime.isDisposed()) {
            return;
        }
        if (seconds == null) {
            seconds = 0;
        }
        this.locked = true;
        try {
            this.dateTime.setSeconds(seconds.intValue());
        }
        finally {
            this.locked = false;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.hoursHolder);
    }
}

