/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal;

import com.ibm.icu.text.Collator;
import java.util.HashSet;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.JptResourceTypeManager;
import org.eclipse.jpt.common.core.internal.InternalJptResourceTypeManager;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;
import org.eclipse.jpt.common.utility.internal.iterable.SuperIterableWrapper;

public class InternalJptResourceType
implements JptResourceType {
    private final InternalJptResourceTypeManager manager;
    private final String id;
    private final IContentType contentType;
    private final String version;
    private String pluginId;
    private HashSet<InternalJptResourceType> baseTypes;

    InternalJptResourceType(InternalJptResourceTypeManager manager, String id, IContentType contentType, String version) {
        this.manager = manager;
        this.id = id;
        this.contentType = contentType;
        this.version = version;
    }

    @Override
    public JptResourceTypeManager getManager() {
        return this.manager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IContentType getContentType() {
        return this.contentType;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    void setBaseTypes(HashSet<InternalJptResourceType> baseTypes) {
        this.baseTypes = baseTypes;
    }

    @Override
    public Iterable<JptResourceType> getBaseTypes() {
        return new SuperIterableWrapper(this.baseTypes);
    }

    @Override
    public boolean isKindOf(JptResourceType resourceType) {
        return this.isKindOf_(resourceType) || this.extends_(resourceType);
    }

    private boolean isKindOf_(JptResourceType resourceType) {
        return this.contentType.isKindOf(resourceType.getContentType()) && this.versionIsGTE(resourceType);
    }

    private boolean versionIsGTE(JptResourceType resourceType) {
        return this.compareVersionTo(resourceType.getVersion()) >= 0;
    }

    private boolean extends_(JptResourceType resourceType) {
        for (JptResourceType jptResourceType : this.baseTypes) {
            if (!jptResourceType.isKindOf(resourceType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(JptResourceType resourceType) {
        int result = Collator.getInstance().compare((Object)this.contentType, (Object)resourceType.getContentType());
        return result != 0 ? result : this.compareVersionTo(resourceType.getVersion());
    }

    private int compareVersionTo(String v) {
        if (this.version.equals("<undetermined>")) {
            return v.equals("<undetermined>") ? 0 : -1;
        }
        if (v.equals("<undetermined>")) {
            return 1;
        }
        return ComparatorTools.integerVersionComparator().compare(this.version, v);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.contentType.getName());
        if (!this.version.equals("<undetermined>")) {
            sb.append(' ');
            sb.append(this.version);
        }
        return sb.toString();
    }
}

