/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.Field;
import org.eclipse.jem.internal.proxy.initParser.Message;
import org.eclipse.jem.internal.proxy.initParser.Statement;

public class Block
extends Expression {
    protected boolean fIsClosed = false;
    protected boolean fIsComplete = false;
    protected boolean fMessageOrField = false;

    public Block(Expression anExpression) {
        this.currentExpression = anExpression;
    }

    public Block(ClassLoader fClassLoader) {
        this.currentExpression = new Statement(fClassLoader);
    }

    @Override
    public Object evaluate() throws Exception {
        return this.currentExpression.evaluate();
    }

    @Override
    public boolean isComplete() {
        return this.fIsComplete;
    }

    @Override
    public Class getTypeClass() throws Exception {
        return this.currentExpression.getTypeClass();
    }

    @Override
    public Expression push(char[] token, char tokenDelimiter) {
        if ((this.fIsClosed || this.currentExpression.isComplete()) && (tokenDelimiter == ')' || tokenDelimiter == ',')) {
            this.fIsComplete = true;
            return this;
        }
        if (this.fMessageOrField) {
            this.fMessageOrField = false;
            if (tokenDelimiter == '(') {
                Message message = new Message(this.currentExpression, token, this.fClassLoader);
                this.currentExpression = message;
                return message;
            }
            Field field = new Field(this.currentExpression, token, this.fClassLoader);
            this.currentExpression = field;
            return field;
        }
        if (this.currentExpression.isComplete() && tokenDelimiter == '.') {
            this.fMessageOrField = true;
            return this;
        }
        Expression result = this.currentExpression.push(token, tokenDelimiter);
        if (result != this.currentExpression) {
            this.pushExpressionStack(result);
        }
        if (this.currentExpression.isComplete() && tokenDelimiter == ')') {
            this.fIsClosed = true;
        }
        return this.currentExpression;
    }

    @Override
    public boolean isPrimitive() throws Exception {
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Block(");
        if (this.currentExpression != null) {
            buffer.append(this.currentExpression.toString());
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    protected String getTypeClassName() {
        return this.currentExpression.getTypeClassName();
    }
}

