/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.DialogBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintOptions;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

class ScalingBlock
extends DialogBlock {
    private final DataBindingContext bindings;
    private final PrintOptions options;

    ScalingBlock(DialogBlock.IDialogUnitConverter dluConverter, DataBindingContext bindings, PrintOptions options) {
        super(dluConverter);
        this.bindings = bindings;
        this.options = options;
    }

    @Override
    public Control createContents(Composite parent) {
        Realm realm = this.bindings.getValidationRealm();
        Group result = this.group(parent, DiagramUIPrintingMessages.JPSPrintDialog_Scaling);
        ScalingBlock.layout((Composite)result, 5);
        Button adjustRadio = this.radio((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_Adjust);
        this.layoutSpanHorizontal((Control)adjustRadio, 2);
        Text textScale = this.text((Composite)result, 20);
        this.layoutSpanHorizontal(this.blank((Composite)result), 2);
        final IObservableValue scalingValue = BeansObservables.observeValue((Realm)realm, (Object)this.options, (String)PrintOptions.PROPERTY_PERCENT_SCALING);
        this.bindings.bindValue((IObservableValue)SWTObservables.observeSelection((Control)adjustRadio), scalingValue, null, null);
        this.bindings.bindValue((IObservableValue)SWTObservables.observeText((Control)textScale, (int)24), BeansObservables.observeValue((Realm)realm, (Object)this.options, (String)PrintOptions.PROPERTY_SCALE_FACTOR), null, null);
        this.bindings.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)textScale), scalingValue, null, null);
        Button fitToRadio = this.radio((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_FitTo);
        ComputedValue fitToValue = new ComputedValue(realm){

            protected Object calculate() {
                return (Boolean)scalingValue.getValue() == false;
            }
        };
        this.bindings.bindValue((IObservableValue)SWTObservables.observeSelection((Control)fitToRadio), (IObservableValue)fitToValue, null, null);
        this.layoutHorizontalIndent(this.layoutAlignRight((Control)this.label((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_PagesWide)));
        Text textWide = this.text((Composite)result, 20);
        this.layoutHorizontalIndent(this.layoutAlignRight((Control)this.label((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_PagesTall)));
        Text textTall = this.text((Composite)result, 20);
        this.bindings.bindValue((IObservableValue)SWTObservables.observeText((Control)textWide, (int)24), BeansObservables.observeValue((Realm)realm, (Object)this.options, (String)PrintOptions.PROPERTY_FIT_TO_WIDTH), null, null);
        this.bindings.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)textWide), (IObservableValue)fitToValue, null, null);
        this.bindings.bindValue((IObservableValue)SWTObservables.observeText((Control)textTall, (int)24), BeansObservables.observeValue((Realm)realm, (Object)this.options, (String)PrintOptions.PROPERTY_FIT_TO_HEIGHT), null, null);
        this.bindings.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)textTall), (IObservableValue)fitToValue, null, null);
        return result;
    }

    @Override
    public void dispose() {
    }
}

