/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.GuideLayer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.SimpleRootEditPart;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;
import org.eclipse.gef.tools.MarqueeDragTracker;

public class FreeformGraphicalRootEditPart
extends SimpleRootEditPart
implements LayerConstants,
LayerManager {
    private LayeredPane innerLayers;
    private LayeredPane printableLayers;
    private PropertyChangeListener gridListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("SnapToGrid.GridOrigin") || property.equals("SnapToGrid.GridSpacing") || property.equals("SnapToGrid.isVisible")) {
                FreeformGraphicalRootEditPart.this.refreshGridLayer();
            }
        }
    };
    static /* synthetic */ Class class$0;

    protected IFigure createFigure() {
        FreeformViewport viewport = new FreeformViewport();
        this.innerLayers = new FreeformLayeredPane();
        this.createLayers(this.innerLayers);
        viewport.setContents((IFigure)this.innerLayers);
        return viewport;
    }

    protected GridLayer createGridLayer() {
        return new GridLayer();
    }

    protected void createLayers(LayeredPane layeredPane) {
        layeredPane.add((IFigure)this.createGridLayer(), (Object)"Grid Layer");
        layeredPane.add((IFigure)this.getPrintableLayers(), (Object)"Printable Layers");
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Handle Layer");
        layeredPane.add((IFigure)new FeedbackLayer(), (Object)"Feedback Layer");
        layeredPane.add((IFigure)new GuideLayer(), (Object)"Guide Layer");
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Primary Layer");
        layeredPane.add((IFigure)new ConnectionLayer(), (Object)"Connection Layer");
        return layeredPane;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.AutoexposeHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new ViewportAutoexposeHelper(this);
        }
        return super.getAdapter(adapter);
    }

    public IFigure getContentPane() {
        return this.getLayer("Primary Layer");
    }

    public DragTracker getDragTracker(Request req) {
        return new MarqueeDragTracker();
    }

    public IFigure getLayer(Object key) {
        if (this.innerLayers == null) {
            return null;
        }
        Layer layer = this.innerLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        if (this.printableLayers == null) {
            return null;
        }
        return this.printableLayers.getLayer(key);
    }

    public Object getModel() {
        return LayerManager.ID;
    }

    protected LayeredPane getPrintableLayers() {
        if (this.printableLayers == null) {
            this.printableLayers = this.createPrintableLayers();
        }
        return this.printableLayers;
    }

    protected void refreshGridLayer() {
        boolean visible = false;
        GridLayer grid = (GridLayer)this.getLayer("Grid Layer");
        Boolean val = (Boolean)this.getViewer().getProperty("SnapToGrid.isVisible");
        if (val != null) {
            visible = val;
        }
        grid.setOrigin((Point)this.getViewer().getProperty("SnapToGrid.GridOrigin"));
        grid.setSpacing((Dimension)this.getViewer().getProperty("SnapToGrid.GridSpacing"));
        grid.setVisible(visible);
    }

    protected void register() {
        super.register();
        if (this.getLayer("Grid Layer") != null) {
            this.getViewer().addPropertyChangeListener(this.gridListener);
            this.refreshGridLayer();
        }
    }

    protected void unregister() {
        this.getViewer().removePropertyChangeListener(this.gridListener);
        super.unregister();
    }

    class FeedbackLayer
    extends FreeformLayer {
        FeedbackLayer() {
            this.setEnabled(false);
        }
    }
}

