/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;

public class SnapToGrid
extends SnapToHelper {
    public static final String PROPERTY_GRID_ENABLED = "SnapToGrid.isEnabled";
    public static final String PROPERTY_GRID_VISIBLE = "SnapToGrid.isVisible";
    public static final String PROPERTY_GRID_SPACING = "SnapToGrid.GridSpacing";
    public static final String PROPERTY_GRID_ORIGIN = "SnapToGrid.GridOrigin";
    public static final int DEFAULT_GRID_SIZE = 12;
    public static final int DEFAULT_GAP = 12;
    protected GraphicalEditPart container;
    protected int gridX;
    protected int gridY;
    protected Point origin;

    public SnapToGrid(GraphicalEditPart container) {
        Point loc;
        this.container = container;
        Dimension spacing = (Dimension)container.getViewer().getProperty(PROPERTY_GRID_SPACING);
        if (spacing != null) {
            this.gridX = spacing.width;
            this.gridY = spacing.height;
        }
        if (this.gridX == 0) {
            this.gridX = 12;
        }
        if (this.gridY == 0) {
            this.gridY = 12;
        }
        this.origin = (loc = (Point)container.getViewer().getProperty(PROPERTY_GRID_ORIGIN)) != null ? loc : new Point();
    }

    public int snapRectangle(Request request, int snapLocations, PrecisionRectangle rect, PrecisionRectangle result) {
        rect = rect.getPreciseCopy();
        this.makeRelative(this.container.getContentPane(), (Translatable)rect);
        PrecisionRectangle correction = new PrecisionRectangle();
        this.makeRelative(this.container.getContentPane(), (Translatable)correction);
        if (this.gridX > 0 && (snapLocations & 0x10) != 0) {
            correction.setPreciseWidth(correction.preciseWidth() - Math.IEEEremainder(rect.preciseRight() - (double)this.origin.x - 1.0, this.gridX));
            snapLocations &= 0xFFFFFFEF;
        }
        if ((snapLocations & 0x48) != 0 && this.gridX > 0) {
            double leftCorrection = Math.IEEEremainder(rect.preciseX() - (double)this.origin.x, this.gridX);
            correction.setPreciseX(correction.preciseX() - leftCorrection);
            if ((snapLocations & 0x40) == 0) {
                correction.setPreciseWidth(correction.preciseWidth() + leftCorrection);
            }
            snapLocations &= 0xFFFFFFB7;
        }
        if ((snapLocations & 4) != 0 && this.gridY > 0) {
            correction.setPreciseHeight(correction.preciseHeight() - Math.IEEEremainder(rect.preciseBottom() - (double)this.origin.y - 1.0, this.gridY));
            snapLocations &= 0xFFFFFFFB;
        }
        if ((snapLocations & 0x81) != 0 && this.gridY > 0) {
            double topCorrection = Math.IEEEremainder(rect.preciseY() - (double)this.origin.y, this.gridY);
            correction.setPreciseY(correction.preciseY() - topCorrection);
            if ((snapLocations & 0x80) == 0) {
                correction.setPreciseHeight(correction.preciseHeight() + topCorrection);
            }
            snapLocations &= 0xFFFFFF7E;
        }
        this.makeAbsolute(this.container.getContentPane(), (Translatable)correction);
        result.setPreciseX(result.preciseX() + correction.preciseX());
        result.setPreciseY(result.preciseY() + correction.preciseY());
        result.setPreciseWidth(result.preciseWidth() + correction.preciseWidth());
        result.setPreciseHeight(result.preciseHeight() + correction.preciseHeight());
        return snapLocations;
    }
}

