/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import javafx.geometry.Orientation;
import javafx.scene.Node;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.mvc.fx.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.ResizeContentOperation;
import org.eclipse.gef.mvc.fx.operations.ResizeOperation;
import org.eclipse.gef.mvc.fx.parts.IResizableContentPart;
import org.eclipse.gef.mvc.fx.policies.AbstractPolicy;

public class ResizePolicy
extends AbstractPolicy {
    protected void applySize(double dw, double dh) {
        this.updateResizeOperation(dw, dh);
        this.locallyExecuteOperation();
    }

    private double bounded(double min, double val, double max) {
        if (max < min) {
            double t = min;
            min = max;
            max = t;
        }
        return Math.max(min, Math.min(max, val));
    }

    @Override
    public ITransactionalOperation commit() {
        ResizeOperation resizeOperation = this.getResizeOperation();
        ITransactionalOperation commitOperation = super.commit();
        if (commitOperation != null && !commitOperation.isNoOp() && this.isContentResizable()) {
            ForwardUndoCompositeOperation composite = new ForwardUndoCompositeOperation("Resize Content");
            composite.add(commitOperation);
            composite.add(this.createResizeContentOperation(resizeOperation));
            commitOperation = composite;
        }
        return commitOperation;
    }

    protected Dimension computeApplicableDelta(double dw, double dh) {
        if (dw != 0.0 || dh != 0.0) {
            double h;
            double w;
            Object visual = this.getHost().getVisual();
            Dimension initialSize = this.getInitialSize();
            Dimension intendedSize = initialSize.getExpanded(dw, dh);
            Orientation contentBias = visual.getContentBias();
            if (contentBias == null) {
                w = this.bounded(visual.minWidth(-1.0), intendedSize.width, visual.maxWidth(-1.0));
                h = this.bounded(visual.minHeight(-1.0), intendedSize.height, visual.maxHeight(-1.0));
            } else if (contentBias == Orientation.HORIZONTAL) {
                w = this.bounded(visual.minWidth(-1.0), intendedSize.width, visual.maxWidth(-1.0));
                h = this.bounded(visual.minHeight(w), intendedSize.height, visual.maxHeight(w));
            } else {
                h = this.bounded(visual.minHeight(-1.0), intendedSize.height, visual.maxHeight(-1.0));
                w = this.bounded(visual.minWidth(h), intendedSize.width, visual.maxWidth(h));
            }
            dw = w - initialSize.width;
            dh = h - initialSize.height;
        }
        return new Dimension(dw, dh);
    }

    @Override
    protected ITransactionalOperation createOperation() {
        return new ResizeOperation("Resize", (IResizableContentPart<? extends Node>)this.getHost(), this.getCurrentSize(), 0.0, 0.0);
    }

    protected ITransactionalOperation createResizeContentOperation(ResizeOperation resizeOperation) {
        Dimension initialSize = resizeOperation.getInitialSize();
        Dimension finalSize = new Dimension(initialSize.getWidth() + resizeOperation.getDw(), initialSize.getHeight() + resizeOperation.getDh());
        ResizeContentOperation resizeContentOperation = new ResizeContentOperation(resizeOperation.getResizablePart(), initialSize, finalSize);
        return resizeContentOperation;
    }

    protected Dimension getCurrentSize() {
        return this.getHost().getVisualSize();
    }

    public double getDeltaHeight() {
        return this.getResizeOperation().getDh();
    }

    public double getDeltaWidth() {
        return this.getResizeOperation().getDw();
    }

    public IResizableContentPart<? extends Node> getHost() {
        return (IResizableContentPart)super.getHost();
    }

    protected Dimension getInitialSize() {
        return this.getResizeOperation().getInitialSize();
    }

    protected ResizeOperation getResizeOperation() {
        return (ResizeOperation)this.getOperation();
    }

    protected boolean isContentResizable() {
        return this.getHost() instanceof IResizableContentPart;
    }

    public void resize(double finalDw, double finalDh) {
        this.checkInitialized();
        this.applySize(finalDw, finalDh);
    }

    protected void updateResizeOperation(double intendedDeltaWidth, double intendedDeltaHeight) {
        Dimension applicableDelta = this.computeApplicableDelta(intendedDeltaWidth, intendedDeltaHeight);
        ResizeOperation op = this.getResizeOperation();
        op.setDw(applicableDelta.width);
        op.setDh(applicableDelta.height);
    }
}

