/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.behaviors;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import org.eclipse.gef.common.collections.CollectionUtils;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IHandlePartFactory;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class SelectionBehavior
extends AbstractBehavior {
    public static final String SELECTION_FEEDBACK_PART_FACTORY = "SELECTION_FEEDBACK_PART_FACTORY";
    public static final String SELECTION_HANDLE_PART_FACTORY = "SELECTION_HANDLE_PART_FACTORY";
    private ListChangeListener<IContentPart<? extends Node>> selectionObserver = new ListChangeListener<IContentPart<? extends Node>>(){

        public void onChanged(ListChangeListener.Change<? extends IContentPart<? extends Node>> c) {
            ArrayList newSelection = new ArrayList(c.getList());
            List oldSelection = CollectionUtils.getPreviousContents(c);
            SelectionBehavior.this.removeFeedbackAndHandles(oldSelection);
            SelectionBehavior.this.addFeedbackAndHandles(newSelection);
        }
    };

    protected void addFeedbackAndHandles(List<? extends IContentPart<? extends Node>> selected) {
        if (!selected.isEmpty()) {
            if (selected.size() == 1) {
                this.addFeedback((IVisualPart<? extends Node>)selected.get(0));
                this.addHandles((IVisualPart<? extends Node>)selected.get(0));
            } else {
                this.addFeedback(selected);
                this.addHandles(selected);
            }
        }
    }

    @Override
    protected void doActivate() {
        SelectionModel selectionModel = this.getSelectionModel();
        selectionModel.getSelectionUnmodifiable().addListener(this.selectionObserver);
        this.addFeedbackAndHandles((List<? extends IContentPart<? extends Node>>)selectionModel.getSelectionUnmodifiable());
    }

    @Override
    protected void doDeactivate() {
        SelectionModel selectionModel = this.getSelectionModel();
        this.removeFeedbackAndHandles((List<? extends IContentPart<? extends Node>>)selectionModel.getSelectionUnmodifiable());
        selectionModel.getSelectionUnmodifiable().removeListener(this.selectionObserver);
    }

    @Override
    protected IFeedbackPartFactory getFeedbackPartFactory(IViewer viewer) {
        return this.getFeedbackPartFactory(viewer, SELECTION_FEEDBACK_PART_FACTORY);
    }

    @Override
    protected IHandlePartFactory getHandlePartFactory(IViewer viewer) {
        return this.getHandlePartFactory(viewer, SELECTION_HANDLE_PART_FACTORY);
    }

    protected SelectionModel getSelectionModel() {
        IViewer viewer = this.getHost().getRoot().getViewer();
        SelectionModel selectionModel = (SelectionModel)((Object)viewer.getAdapter(SelectionModel.class));
        return selectionModel;
    }

    protected void removeFeedbackAndHandles(List<? extends IContentPart<? extends Node>> selected) {
        if (!selected.isEmpty()) {
            if (selected.size() == 1) {
                this.removeHandles((IVisualPart<? extends Node>)selected.get(0));
                this.removeFeedback((IVisualPart<? extends Node>)selected.get(0));
            } else {
                this.removeHandles(selected);
                this.removeFeedback(selected);
            }
        }
    }
}

