/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.geometry.projective;

import org.eclipse.gef.geometry.planar.Point;

public final class Vector3D {
    public double x;
    public double y;
    public double z;

    public Vector3D(double px, double py, double pz) {
        this.x = px;
        this.y = py;
        this.z = pz;
    }

    public Vector3D(Point p) {
        this(p.x, p.y, 1.0);
    }

    public boolean equals(Object other) {
        if (other instanceof Vector3D) {
            Vector3D o = (Vector3D)other;
            Point tmp = this.toPoint();
            if (tmp == null) {
                return o.toPoint() == null;
            }
            return tmp.equals(o.toPoint());
        }
        return false;
    }

    public Vector3D getAdded(Vector3D other) {
        return new Vector3D(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vector3D getCopy() {
        return new Vector3D(this.x, this.y, this.z);
    }

    public Vector3D getCrossProduct(Vector3D other) {
        return new Vector3D(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public double getDotProduct(Vector3D other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector3D getRatio(Vector3D other, double t) {
        return this.getAdded(other.getSubtracted(this).getScaled(t));
    }

    public Vector3D getScaled(double f) {
        return new Vector3D(this.x * f, this.y * f, this.z * f);
    }

    public Vector3D getSubtracted(Vector3D other) {
        return new Vector3D(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public int hashCode() {
        return 0;
    }

    public Point toPoint() {
        if (this.z == 0.0) {
            return null;
        }
        return new Point(this.x / this.z, this.y / this.z);
    }

    public String toString() {
        return "Vector3D(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

