/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.security.ui.Activator;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.internal.security.ui.storage.StorageUtils;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class StorageLoginDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION_NEW = "StorageLoginDialogNew";
    private static final String DIALOG_SETTINGS_SECTION_OLD = "StorageLoginDialogOld";
    private static final String HELP_ID = "org.eclipse.equinox.security.ui.StorageLoginDialog";
    private static final ImageDescriptor dlgImageDescriptor = ImageDescriptor.createFromFile(StorageLoginDialog.class, (String)"/icons/storage/login_wiz.png");
    private static final String DIGEST_ALGORITHM = "MD5";
    protected Text password;
    protected Text confirm;
    protected Button showPassword;
    protected Button okButton;
    protected PBEKeySpec generatedPassword;
    protected final boolean confirmPassword;
    protected final boolean passwordChange;
    protected final String location;
    private Image dlgTitleImage = null;

    public StorageLoginDialog(boolean confirmPassword, boolean passwordChange, String location) {
        super(StorageUtils.getShell());
        this.confirmPassword = confirmPassword;
        this.passwordChange = passwordChange;
        this.location = location;
    }

    public PBEKeySpec getGeneratedPassword() {
        return this.generatedPassword;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, SecUIMessages.buttonLogin, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, SecUIMessages.buttonExit, false);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String settingsID;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(settingsID = this.confirmPassword ? DIALOG_SETTINGS_SECTION_NEW : DIALOG_SETTINGS_SECTION_OLD);
        if (section == null) {
            section = settings.addNewSection(settingsID);
        }
        return section;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SecUIMessages.generalDialogTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELP_ID);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.dlgTitleImage = dlgImageDescriptor.createImage();
        this.setTitleImage(this.dlgTitleImage);
        if (this.dlgTitleImage != null) {
            contents.addDisposeListener(e -> this.dlgTitleImage.dispose());
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeTop = (Composite)super.createDialogArea(parent);
        String titleMsg = this.confirmPassword ? SecUIMessages.passwordChangeTitle : (this.passwordChange ? SecUIMessages.messageLoginChange : SecUIMessages.dialogTitle);
        this.setTitle(titleMsg);
        Composite composite = new Composite(compositeTop, 0);
        new Label(composite, 16384).setText(SecUIMessages.labelPassword);
        this.password = new Text(composite, 18432);
        this.password.addModifyListener(event -> this.okButton.setEnabled(this.validatePassword()));
        if (this.confirmPassword) {
            new Label(composite, 16384).setText(SecUIMessages.labelConfirm);
            this.confirm = new Text(composite, 18432);
            this.confirm.addModifyListener(event -> this.okButton.setEnabled(this.validatePassword()));
        } else {
            this.confirm = null;
        }
        new Label(composite, 16384);
        this.showPassword = new Button(composite, 131104);
        this.showPassword.setText(SecUIMessages.showPassword);
        this.showPassword.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StorageLoginDialog.this.passwordVisibility();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StorageLoginDialog.this.passwordVisibility();
            }
        });
        this.showPassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.showPassword.setSelection(false);
        this.passwordVisibility();
        if (this.location != null) {
            Group locationGroup = new Group(composite, 0);
            locationGroup.setText(SecUIMessages.locationGroup);
            GridData groupData = new GridData(4, 4, true, true);
            groupData.horizontalSpan = 2;
            locationGroup.setLayoutData((Object)groupData);
            locationGroup.setLayout((Layout)new GridLayout());
            Label locationLabel = new Label((Composite)locationGroup, 64);
            locationLabel.setText(new Path(this.location).toOSString());
        }
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.swtDefaults().numColumns(2).generateLayout(composite);
        return compositeTop;
    }

    protected void passwordVisibility() {
        boolean selected = this.showPassword.getSelection();
        if (selected) {
            this.password.setEchoChar('\u0000');
            if (this.confirm != null) {
                this.confirm.setEchoChar('\u0000');
            }
        } else {
            this.password.setEchoChar('*');
            if (this.confirm != null) {
                this.confirm.setEchoChar('*');
            }
        }
    }

    protected boolean validatePassword() {
        String password2;
        String password1 = this.password.getText();
        if (password1 == null || password1.length() == 0) {
            this.setMessage(SecUIMessages.messageEmptyPassword, 3);
            return false;
        }
        if (this.confirm != null && !password1.equals(password2 = this.confirm.getText())) {
            this.setMessage(SecUIMessages.messageNoMatch, 2);
            return false;
        }
        this.setMessage("", 0);
        return true;
    }

    protected void okPressed() {
        String internalPassword;
        try {
            MessageDigest digest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            byte[] digested = digest.digest(new String(this.password.getText()).getBytes());
            internalPassword = EncodingUtils.encodeBase64((byte[])digested);
        }
        catch (NoSuchAlgorithmException e) {
            Activator.log(2, SecUIMessages.noDigestPassword, new Object[]{DIGEST_ALGORITHM}, e);
            internalPassword = this.password.getText();
        }
        this.generatedPassword = new PBEKeySpec(internalPassword.toCharArray());
        super.okPressed();
    }
}

