/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiResources;
import org.eclipse.epp.internal.mpc.ui.css.StyleHelper;
import org.eclipse.epp.internal.mpc.ui.wizards.CatalogToolTip;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class CatalogSwitcherItem
extends Composite {
    public static final int ITEM_MARGIN = 5;
    public static final String KEY_SELECTED = String.valueOf(CatalogSwitcherItem.class.getName()) + ":selected";
    private final ImageRegistry imageRegistry;
    private Label iconLabel;
    private ListenerList<SelectionListener> selectionListeners;
    private MouseListener selectionHandler;

    public CatalogSwitcherItem(Composite parent, ImageRegistry imageRegistry, CatalogDescriptor catalogDescriptor) {
        super(parent, 0);
        this.setData(catalogDescriptor);
        this.imageRegistry = imageRegistry;
        this.createContent();
    }

    public CatalogDescriptor getCatalogDescriptor() {
        return (CatalogDescriptor)this.getData();
    }

    protected void createContent() {
        CatalogSwitcherItem container = this;
        container.setBackgroundMode(1);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        StyleHelper styleHelper = new StyleHelper().on((Widget)container);
        styleHelper.setClass("Catalog");
        this.iconLabel = new Label((Composite)container, 0);
        this.iconLabel.setImage(this.getDefaultCatalogImage());
        styleHelper.on((Widget)this.iconLabel).setClass("CatalogImage");
        CatalogDescriptor catalogDescriptor = this.getCatalogDescriptor();
        this.retrieveCatalogImage(catalogDescriptor, this.iconLabel);
        CatalogToolTip.attachCatalogToolTip(this.iconLabel, catalogDescriptor);
    }

    private void retrieveCatalogImage(final CatalogDescriptor catalogDescriptor, final Label label) {
        Job job = new Job(Messages.CatalogSwitcher_retrieveMetaData){

            protected IStatus run(IProgressMonitor monitor) {
                if (label.isDisposed()) {
                    return Status.OK_STATUS;
                }
                monitor.beginTask(NLS.bind((String)Messages.CatalogSwitcher_downloadCatalogImage, (Object)catalogDescriptor.getLabel()), 1);
                Image image = CatalogSwitcherItem.this.getCatalogIcon(catalogDescriptor);
                monitor.worked(1);
                if (image != null && !label.isDisposed()) {
                    label.getDisplay().asyncExec(() -> {
                        if (!label.isDisposed() && !image.isDisposed()) {
                            label.setImage(image);
                        }
                    });
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(50);
        job.schedule();
    }

    private Image getCatalogIcon(CatalogDescriptor catalogDescriptor) {
        String key = catalogDescriptor.getUrl().toExternalForm();
        Image image = this.imageRegistry.get(key);
        if (image == null) {
            ImageDescriptor catalogIcon = catalogDescriptor.getIcon();
            if (catalogIcon == null) {
                return this.getDefaultCatalogImage();
            }
            this.imageRegistry.put(key, catalogIcon);
            image = this.imageRegistry.get(key);
            if (image == null) {
                return this.getDefaultCatalogImage();
            }
        }
        return image;
    }

    private Image getDefaultCatalogImage() {
        return MarketplaceClientUiResources.getInstance().getImageRegistry().get("NO_ICON_PROVIDED_CATALOG");
    }

    public void setSelected(boolean selected) {
        this.setData(KEY_SELECTED, selected);
        this.setSelectedBackground(selected);
    }

    protected void setSelectedBackground(boolean selected) {
        Color color = selected ? this.getSelectedBackground() : this.getParent().getBackground();
        this.setBackground(color);
        this.iconLabel.setBackground(color);
    }

    protected Color getSelectedBackground() {
        return this.getDisplay().getSystemColor(26);
    }

    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getData(KEY_SELECTED));
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.selectionListeners == null) {
            ListenerList selectionListeners;
            this.selectionListeners = selectionListeners = new ListenerList();
            this.selectionHandler = MouseListener.mouseUpAdapter(e -> {
                Event untyped = new Event();
                untyped.widget = this;
                untyped.display = e.display;
                untyped.widget = e.widget;
                untyped.time = e.time;
                untyped.data = this.getData();
                untyped.item = e.widget;
                untyped.x = e.x;
                untyped.y = e.y;
                untyped.stateMask = e.stateMask;
                untyped.doit = true;
                SelectionEvent selectionEvent = new SelectionEvent(untyped);
                this.fireSelectionEvent(selectionEvent);
            });
            this.iconLabel.addMouseListener(this.selectionHandler);
        }
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.selectionListeners == null) {
            return;
        }
        this.selectionListeners.remove((Object)listener);
        if (this.selectionListeners.isEmpty()) {
            if (this.selectionHandler != null) {
                this.iconLabel.removeMouseListener(this.selectionHandler);
                this.selectionHandler = null;
            }
            this.selectionListeners = null;
        }
    }

    protected void fireSelectionEvent(SelectionEvent selectionEvent) {
        ListenerList<SelectionListener> currentListeners = this.selectionListeners;
        if (currentListeners == null) {
            return;
        }
        for (SelectionListener listener : currentListeners) {
            listener.widgetSelected(selectionEvent);
        }
    }
}

