/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.util.List;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.CacheCredentialsAuthenticationStrategy;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.CacheCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.ChainedCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientCustomizer;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientTransport;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpServiceContext;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.SynchronizedCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.SystemCredentialsProvider;
import org.eclipse.userstorage.internal.StorageProperties;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(name="org.eclipse.epp.mpc.core.http.client.factory", service={HttpClientFactory.class})
public class HttpClientFactory {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.STATIC, fieldOption=FieldOption.REPLACE)
    private List<HttpClientCustomizer> customizers;

    public List<HttpClientCustomizer> getCustomizers() {
        return this.customizers;
    }

    public void setCustomizers(List<HttpClientCustomizer> customizers) {
        this.customizers = customizers;
    }

    public HttpServiceContext build() {
        return this.build(null);
    }

    public HttpServiceContext build(HttpServiceContext oldContext) {
        CredentialsProvider credentialsProvider;
        CredentialsProvider initialCredentialsProvider;
        CredentialsProvider cacheProvider;
        CookieStore cookieStore;
        HttpClientBuilder clientBuilder = this.builder();
        CookieStore cookieStore2 = cookieStore = oldContext == null ? null : oldContext.getCookieStore();
        if (cookieStore == null) {
            cookieStore = this.createCookieStore();
        }
        CredentialsProvider credentialsProvider2 = cacheProvider = oldContext == null ? null : oldContext.getCredentialsCacheProvider();
        if (cacheProvider == null) {
            cacheProvider = this.createCredentialsCacheProvider();
        }
        CredentialsProvider credentialsProvider3 = initialCredentialsProvider = oldContext == null ? null : oldContext.getInitialCredentialsProvider();
        if (initialCredentialsProvider == null) {
            initialCredentialsProvider = this.createCredentialsProvider();
        }
        if ((credentialsProvider = initialCredentialsProvider) != null) {
            credentialsProvider = this.customizeCredentialsProvider(clientBuilder, credentialsProvider, cacheProvider);
        }
        clientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        clientBuilder.setDefaultCookieStore(cookieStore);
        clientBuilder = this.customizeBuilder(clientBuilder);
        return new HttpServiceContext(clientBuilder.build(), cookieStore, credentialsProvider, initialCredentialsProvider, cacheProvider);
    }

    protected CredentialsProvider createCredentialsProvider() {
        return new SystemCredentialsProvider();
    }

    protected CredentialsProvider createCredentialsCacheProvider() {
        return new CacheCredentialsProvider();
    }

    protected CookieStore createCookieStore() {
        return new BasicCookieStore();
    }

    private CredentialsProvider customizeCredentialsProvider(HttpClientBuilder clientBuilder, CredentialsProvider credentialsProvider, CredentialsProvider cacheProvider) {
        credentialsProvider = this.customizeCredentialsProvider(credentialsProvider);
        if (cacheProvider != null) {
            credentialsProvider = new ChainedCredentialsProvider(cacheProvider, credentialsProvider);
            clientBuilder.addInterceptorFirst((request, context) -> context.setAttribute(CacheCredentialsAuthenticationStrategy.CREDENTIALS_CACHE_ATTRIBUTE, (Object)cacheProvider));
        }
        credentialsProvider = new SynchronizedCredentialsProvider(credentialsProvider);
        return credentialsProvider;
    }

    protected HttpClientBuilder builder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setMaxConnPerRoute(100).setMaxConnTotal(200);
        HttpClientFactory.setClientDefaultTimeouts(builder);
        builder.setTargetAuthenticationStrategy((AuthenticationStrategy)new CacheCredentialsAuthenticationStrategy.Target((AuthenticationStrategy)TargetAuthenticationStrategy.INSTANCE));
        builder.setProxyAuthenticationStrategy((AuthenticationStrategy)new CacheCredentialsAuthenticationStrategy.Proxy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE));
        builder.setUserAgent(HttpClientTransport.USER_AGENT);
        return builder;
    }

    private static void setClientDefaultTimeouts(HttpClientBuilder builder) {
        int connectTimeoutUssDefault = StorageProperties.getProperty((String)"org.eclipse.userstorage.connectTimeout", (int)HttpClientTransport.DEFAULT_CONNECT_TIMEOUT);
        int readTimeoutUssDefault = StorageProperties.getProperty((String)"org.eclipse.userstorage.socketTimeout", (int)HttpClientTransport.DEFAULT_READ_TIMEOUT);
        int connectTimeout = HttpClientFactory.getTimeoutValue(HttpClientTransport.CONNECT_TIMEOUT_PROPERTY, connectTimeoutUssDefault);
        int readTimeout = HttpClientFactory.getTimeoutValue(HttpClientTransport.READ_TIMEOUT_PROPERTY, readTimeoutUssDefault);
        int connectionRequestTimeout = HttpClientFactory.getTimeoutValue(HttpClientTransport.CONNECTION_REQUEST_TIMEOUT_PROPERTY, HttpClientTransport.DEFAULT_CONNECTION_REQUEST_TIMEOUT);
        SocketConfig defaultSocketConfig = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(readTimeout).setTcpNoDelay(true).build();
        RequestConfig defaultRequestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
        builder.setDefaultSocketConfig(defaultSocketConfig);
        builder.setDefaultRequestConfig(defaultRequestConfig);
    }

    private static int getTimeoutValue(String property, int defaultValue) {
        String propertyValue = FrameworkUtil.getBundle(HttpClientTransport.class).getBundleContext().getProperty(property);
        if (propertyValue == null || "".equals(propertyValue)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    protected HttpClientBuilder customizeBuilder(HttpClientBuilder builder) {
        HttpClientBuilder customBuilder = builder;
        for (HttpClientCustomizer customizer : this.customizers) {
            customBuilder = HttpClientFactory.customizeBuilder(customizer, customBuilder);
        }
        return customBuilder;
    }

    private static HttpClientBuilder customizeBuilder(HttpClientCustomizer customizer, HttpClientBuilder builder) {
        if (customizer == null) {
            return builder;
        }
        HttpClientBuilder customBuilder = customizer.customizeBuilder(builder);
        return customBuilder == null ? builder : customBuilder;
    }

    private CredentialsProvider customizeCredentialsProvider(CredentialsProvider credentialsProvider) {
        CredentialsProvider customizedCredentialsProvider = credentialsProvider;
        for (HttpClientCustomizer customizer : this.customizers) {
            customizedCredentialsProvider = HttpClientFactory.customizeCredentialsProvider(customizer, customizedCredentialsProvider);
        }
        return customizedCredentialsProvider;
    }

    private static CredentialsProvider customizeCredentialsProvider(HttpClientCustomizer customizer, CredentialsProvider credentialsProvider) {
        if (customizer == null) {
            return credentialsProvider;
        }
        CredentialsProvider customCredentialsProvider = customizer.customizeCredentialsProvider(credentialsProvider);
        return customCredentialsProvider == null ? credentialsProvider : customCredentialsProvider;
    }
}

