/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.validation.model.VTValidationFactory;
import org.eclipse.emf.ecp.view.template.style.validation.model.VTValidationStyleProperty;
import org.eclipse.emfforms.internal.swt.core.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SWTValidationHelper {
    public static final SWTValidationHelper INSTANCE = new SWTValidationHelper();
    private final Map<String, Color> colorMap = new LinkedHashMap<String, Color>();
    private VTValidationStyleProperty defaultValidationStyle;

    public Color getValidationBackgroundColor(int severity, VElement vElement, ViewModelContext viewModelContext) {
        VTValidationStyleProperty defaultStyle = this.getDefaultValidationStyle();
        String colorHex = null;
        switch (severity) {
            case 0: {
                colorHex = this.getOkColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 1: {
                colorHex = this.getInfoColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 2: {
                colorHex = this.getWarningColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 4: {
                colorHex = this.getErrorColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 8: {
                colorHex = this.getCancelColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified severity value " + severity + " is invalid. See Diagnostic class.");
            }
        }
        if (colorHex == null) {
            return null;
        }
        if (!this.colorMap.containsKey(colorHex)) {
            this.colorMap.put(colorHex, this.getColor(colorHex));
        }
        return this.colorMap.get(colorHex);
    }

    public Color getValidationForegroundColor(int severity, VElement vElement, ViewModelContext viewModelContext) {
        VTValidationStyleProperty defaultStyle = this.getDefaultValidationStyle();
        String colorHex = null;
        switch (severity) {
            case 0: {
                colorHex = this.getOkForegroundColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 1: {
                colorHex = this.getInfoForegroundColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 2: {
                colorHex = this.getWarningForegroundColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 4: {
                colorHex = this.getErrorForegroundColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 8: {
                colorHex = this.getCancelForegroundColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified severity value " + severity + " is invalid. See Diagnostic class.");
            }
        }
        if (colorHex == null) {
            return null;
        }
        if (!this.colorMap.containsKey(colorHex)) {
            this.colorMap.put(colorHex, this.getColor(colorHex));
        }
        return this.colorMap.get(colorHex);
    }

    public Color getValidationBackgroundColor(int severity) {
        return this.getValidationBackgroundColor(severity, null, null);
    }

    public Color getValidationForegroundColor(int severity) {
        return this.getValidationForegroundColor(severity, null, null);
    }

    public String getValidationColorHEX(int severity, VElement vElement, ViewModelContext viewModelContext) {
        VTValidationStyleProperty defaultStyle = this.getDefaultValidationStyle();
        String colorHex = null;
        switch (severity) {
            case 0: {
                colorHex = this.getOkColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 1: {
                colorHex = this.getInfoColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 2: {
                colorHex = this.getWarningColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 4: {
                colorHex = this.getErrorColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 8: {
                colorHex = this.getCancelColorHEX(defaultStyle, vElement, viewModelContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified severity value " + severity + " is invalid. See Diagnostic class.");
            }
        }
        return colorHex;
    }

    public Image getValidationIcon(int severity, VElement vElement, ViewModelContext viewModelContext) {
        VTValidationStyleProperty defaultStyle = this.getDefaultValidationStyle();
        String imageUrl = null;
        switch (severity) {
            case 0: {
                imageUrl = this.getOkImageURL(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 1: {
                imageUrl = this.getInfoImageURL(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 2: {
                imageUrl = this.getWarningImageURL(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 4: {
                imageUrl = this.getErrorImageURL(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 8: {
                imageUrl = this.getCancelImageURL(defaultStyle, vElement, viewModelContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified severity value " + severity + " is invalid. See Diagnostic class.");
            }
        }
        if (imageUrl == null) {
            return null;
        }
        try {
            return Activator.getImage(new URL(imageUrl));
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public Image getValidationIcon(int severity) {
        return this.getValidationIcon(severity, null, null);
    }

    public ImageDescriptor getValidationOverlayDescriptor(int severity, VElement vElement, ViewModelContext viewModelContext) {
        VTValidationStyleProperty defaultStyle = this.getDefaultValidationStyle();
        String imageUrl = null;
        switch (severity) {
            case 0: {
                imageUrl = this.getOkOverlayURL(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 1: {
                imageUrl = this.getInfoOverlayURL(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 2: {
                imageUrl = this.getWarningOverlayURL(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 4: {
                imageUrl = this.getErrorOverlayURL(defaultStyle, vElement, viewModelContext);
                break;
            }
            case 8: {
                imageUrl = this.getCancelOverlayURL(defaultStyle, vElement, viewModelContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified severity value " + severity + " is invalid. See Diagnostic class.");
            }
        }
        if (imageUrl == null) {
            return null;
        }
        try {
            return ImageDescriptor.createFromURL((URL)new URL(imageUrl));
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public ImageDescriptor getValidationOverlayDescriptor(int severity) {
        return this.getValidationOverlayDescriptor(severity, null, null);
    }

    private String getOkColorHEX(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            colorHex = defaultStyle.getOkColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getOkColorHEX();
        }
        return colorHex;
    }

    private String getOkForegroundColorHEX(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            colorHex = defaultStyle.getOkForegroundColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getOkForegroundColorHEX();
        }
        return colorHex;
    }

    private String getInfoColorHEX(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            colorHex = defaultStyle.getInfoColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getInfoColorHEX();
        }
        return colorHex;
    }

    private String getInfoForegroundColorHEX(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            colorHex = defaultStyle.getInfoForegroundColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getInfoForegroundColorHEX();
        }
        return colorHex;
    }

    private String getWarningColorHEX(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            colorHex = defaultStyle.getWarningColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getWarningColorHEX();
        }
        return colorHex;
    }

    private String getWarningForegroundColorHEX(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            colorHex = defaultStyle.getWarningForegroundColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getWarningForegroundColorHEX();
        }
        return colorHex;
    }

    private String getErrorColorHEX(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            colorHex = defaultStyle.getErrorColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getErrorColorHEX();
        }
        return colorHex;
    }

    private String getErrorForegroundColorHEX(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            colorHex = defaultStyle.getErrorForegroundColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getErrorForegroundColorHEX();
        }
        return colorHex;
    }

    private String getCancelColorHEX(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            colorHex = defaultStyle.getCancelColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getCancelColorHEX();
        }
        return colorHex;
    }

    private String getCancelForegroundColorHEX(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            colorHex = defaultStyle.getCancelForegroundColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getCancelForegroundColorHEX();
        }
        return colorHex;
    }

    private String getOkImageURL(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String imageURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            imageURL = defaultStyle.getOkImageURL();
        }
        if (validationStyleProperty != null) {
            imageURL = validationStyleProperty.getOkImageURL();
        }
        return imageURL;
    }

    private String getInfoImageURL(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String imageURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            imageURL = defaultStyle.getInfoImageURL();
        }
        if (validationStyleProperty != null) {
            imageURL = validationStyleProperty.getInfoImageURL();
        }
        return imageURL;
    }

    private String getWarningImageURL(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String imageURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            imageURL = defaultStyle.getWarningImageURL();
        }
        if (validationStyleProperty != null) {
            imageURL = validationStyleProperty.getWarningImageURL();
        }
        return imageURL;
    }

    private String getErrorImageURL(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String imageURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            imageURL = defaultStyle.getErrorImageURL();
        }
        if (validationStyleProperty != null) {
            imageURL = validationStyleProperty.getErrorImageURL();
        }
        return imageURL;
    }

    private String getCancelImageURL(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String imageURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            imageURL = defaultStyle.getCancelImageURL();
        }
        if (validationStyleProperty != null) {
            imageURL = validationStyleProperty.getCancelImageURL();
        }
        return imageURL;
    }

    private String getOkOverlayURL(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String overlayURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            overlayURL = defaultStyle.getOkOverlayURL();
        }
        if (validationStyleProperty != null) {
            overlayURL = validationStyleProperty.getOkOverlayURL();
        }
        return overlayURL;
    }

    private String getInfoOverlayURL(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String overlayURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            overlayURL = defaultStyle.getInfoOverlayURL();
        }
        if (validationStyleProperty != null) {
            overlayURL = validationStyleProperty.getInfoOverlayURL();
        }
        return overlayURL;
    }

    private String getWarningOverlayURL(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String overlayURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            overlayURL = defaultStyle.getWarningOverlayURL();
        }
        if (validationStyleProperty != null) {
            overlayURL = validationStyleProperty.getWarningOverlayURL();
        }
        return overlayURL;
    }

    private String getErrorOverlayURL(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String overlayURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            overlayURL = defaultStyle.getErrorOverlayURL();
        }
        if (validationStyleProperty != null) {
            overlayURL = validationStyleProperty.getErrorOverlayURL();
        }
        return overlayURL;
    }

    private String getCancelOverlayURL(VTValidationStyleProperty defaultStyle, VElement vElement, ViewModelContext viewModelContext) {
        String overlayURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (defaultStyle != null) {
            overlayURL = defaultStyle.getCancelOverlayURL();
        }
        if (validationStyleProperty != null) {
            overlayURL = validationStyleProperty.getCancelOverlayURL();
        }
        return overlayURL;
    }

    private VTValidationStyleProperty getValidationStyleProperty(VElement vElement, ViewModelContext viewModelContext) {
        VTValidationStyleProperty validationStyleProperty = null;
        if (vElement != null && viewModelContext != null) {
            VTViewTemplateProvider vtViewTemplateProvider = Activator.getDefault().getVTViewTemplateProvider();
            if (vtViewTemplateProvider == null) {
                return validationStyleProperty;
            }
            Set styleProperties = vtViewTemplateProvider.getStyleProperties(vElement, viewModelContext);
            for (VTStyleProperty styleProperty : styleProperties) {
                if (!VTValidationStyleProperty.class.isInstance(styleProperty)) continue;
                validationStyleProperty = (VTValidationStyleProperty)VTValidationStyleProperty.class.cast(styleProperty);
                break;
            }
        }
        return validationStyleProperty;
    }

    private VTValidationStyleProperty getDefaultValidationStyle() {
        if (this.defaultValidationStyle == null) {
            this.defaultValidationStyle = VTValidationFactory.eINSTANCE.createValidationStyleProperty();
            this.defaultValidationStyle.setOkColorHEX("ffffff");
            this.defaultValidationStyle.setErrorColorHEX("ff0000");
            this.defaultValidationStyle.setWarningColorHEX("FFD800");
            this.defaultValidationStyle.setErrorImageURL(Activator.getDefault().getBundle().getResource("icons/validation_error.png").toExternalForm());
            this.defaultValidationStyle.setErrorOverlayURL(Activator.getDefault().getBundle().getResource("icons/error_decorate.png").toExternalForm());
            this.defaultValidationStyle.setWarningImageURL(Activator.getDefault().getBundle().getResource("icons/validation_warning.png").toExternalForm());
            this.defaultValidationStyle.setWarningOverlayURL(Activator.getDefault().getBundle().getResource("icons/warning_decorate.png").toExternalForm());
            this.defaultValidationStyle.setInfoOverlayURL(Activator.getDefault().getBundle().getResource("icons/info_decorate.gif").toExternalForm());
        }
        return this.defaultValidationStyle;
    }

    private Color getColor(String colorHex) {
        String redString = colorHex.substring(0, 2);
        String greenString = colorHex.substring(2, 4);
        String blueString = colorHex.substring(4, 6);
        int red = Integer.parseInt(redString, 16);
        int green = Integer.parseInt(greenString, 16);
        int blue = Integer.parseInt(blueString, 16);
        return new Color((Device)Display.getDefault(), red, green, blue);
    }
}

