/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedPropertySheetPage
extends PropertySheetPage {
    protected List<Object> objectsToSelect = new ArrayList<Object>();
    protected AdapterFactoryEditingDomain editingDomain;
    protected IAction locateValueAction = new LocateValueAction();

    public ExtendedPropertySheetPage(AdapterFactoryEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    protected void setSelectionToViewer(List<?> selection) {
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        toolBarManager.add(this.locateValueAction);
    }

    public void handleEntrySelection(ISelection selection) {
        PropertySheetEntry entry;
        Object[] values;
        Object object;
        IStructuredSelection structuredSelection;
        super.handleEntrySelection(selection);
        this.objectsToSelect.clear();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (object = structuredSelection.getFirstElement()) instanceof PropertySheetEntry && (values = (entry = (PropertySheetEntry)object).getValues()) != null) {
            int i = 0;
            while (i < values.length) {
                Object value = values[i];
                if (value instanceof IItemPropertySource) {
                    Object realValue = ((IItemPropertySource)value).getEditableValue(null);
                    if (realValue instanceof Collection) {
                        for (Object o : (Collection)realValue) {
                            this.addObjectToSelect(o);
                        }
                    } else {
                        this.addObjectToSelect(realValue);
                    }
                }
                ++i;
            }
        }
        this.locateValueAction.setEnabled(!this.objectsToSelect.isEmpty());
    }

    protected void addObjectToSelect(Object object) {
        if (object instanceof EObject) {
            this.objectsToSelect.add(object);
        }
    }

    protected class LocateValueAction
    extends Action {
        private static final long serialVersionUID = 1L;

        public LocateValueAction() {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_LocateValue_action"));
            this.setToolTipText(EMFEditUIPlugin.INSTANCE.getString("_UI_LocateValue_action_tool_tip"));
            this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage("full/elcl16/LocateValue")));
            this.setDisabledImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage("full/dlcl16/LocateValue")));
        }

        public void run() {
            ArrayList<Object> selection = new ArrayList<Object>();
            for (Object object : ExtendedPropertySheetPage.this.objectsToSelect) {
                selection.add(ExtendedPropertySheetPage.this.editingDomain.getWrapper(object));
            }
            ExtendedPropertySheetPage.this.setSelectionToViewer(selection);
        }
    }
}

