/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.formatting2;

import com.google.inject.Provider;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.dsl.model.AbstractControlFactory;
import org.eclipse.emf.parsley.dsl.model.AbstractFeatureCaptionProviderWithLabel;
import org.eclipse.emf.parsley.dsl.model.AbstractFeatureProvider;
import org.eclipse.emf.parsley.dsl.model.Binding;
import org.eclipse.emf.parsley.dsl.model.BindingsSpecification;
import org.eclipse.emf.parsley.dsl.model.Configurator;
import org.eclipse.emf.parsley.dsl.model.ControlFactorySpecification;
import org.eclipse.emf.parsley.dsl.model.ExtendsClause;
import org.eclipse.emf.parsley.dsl.model.FeatureAssociatedExpression;
import org.eclipse.emf.parsley.dsl.model.FeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.FeatureSpecification;
import org.eclipse.emf.parsley.dsl.model.FieldSpecification;
import org.eclipse.emf.parsley.dsl.model.LabelProvider;
import org.eclipse.emf.parsley.dsl.model.MenuBuilder;
import org.eclipse.emf.parsley.dsl.model.Model;
import org.eclipse.emf.parsley.dsl.model.ModelPackage;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PartsSpecifications;
import org.eclipse.emf.parsley.dsl.model.PolymorphicSpecification;
import org.eclipse.emf.parsley.dsl.model.ProposalCreator;
import org.eclipse.emf.parsley.dsl.model.ProviderBinding;
import org.eclipse.emf.parsley.dsl.model.ResourceManager;
import org.eclipse.emf.parsley.dsl.model.SimpleMethodSpecification;
import org.eclipse.emf.parsley.dsl.model.TableLabelProvider;
import org.eclipse.emf.parsley.dsl.model.TableViewerContentProvider;
import org.eclipse.emf.parsley.dsl.model.TypeBinding;
import org.eclipse.emf.parsley.dsl.model.ValueBinding;
import org.eclipse.emf.parsley.dsl.model.ViewSpecification;
import org.eclipse.emf.parsley.dsl.model.ViewerContentProvider;
import org.eclipse.emf.parsley.dsl.model.WithExpressions;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.emf.parsley.dsl.model.WithFeatureAssociatedExpressions;
import org.eclipse.emf.parsley.dsl.model.WithFields;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.xbase.annotations.formatting2.XbaseWithAnnotationsFormatter;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

public class EmfParsleyDslFormatter
extends XbaseWithAnnotationsFormatter {
    public void format(Object o, IFormattableDocument document) {
        if (o instanceof AbstractControlFactory) {
            this._format((AbstractControlFactory)o, document);
            return;
        }
        if (o instanceof AbstractFeatureCaptionProviderWithLabel) {
            this._format((AbstractFeatureCaptionProviderWithLabel)o, document);
            return;
        }
        if (o instanceof AbstractFeatureProvider) {
            this._format((AbstractFeatureProvider)o, document);
            return;
        }
        if (o instanceof Configurator) {
            this._format((Configurator)o, document);
            return;
        }
        if (o instanceof FeatureCaptionProvider) {
            this._format((FeatureCaptionProvider)o, document);
            return;
        }
        if (o instanceof LabelProvider) {
            this._format((LabelProvider)o, document);
            return;
        }
        if (o instanceof MenuBuilder) {
            this._format((MenuBuilder)o, document);
            return;
        }
        if (o instanceof ProposalCreator) {
            this._format((ProposalCreator)o, document);
            return;
        }
        if (o instanceof ResourceManager) {
            this._format((ResourceManager)o, document);
            return;
        }
        if (o instanceof TableLabelProvider) {
            this._format((TableLabelProvider)o, document);
            return;
        }
        if (o instanceof TableViewerContentProvider) {
            this._format((TableViewerContentProvider)o, document);
            return;
        }
        if (o instanceof ViewerContentProvider) {
            this._format((ViewerContentProvider)o, document);
            return;
        }
        if (o instanceof ControlFactorySpecification) {
            this._format((ControlFactorySpecification)o, document);
            return;
        }
        if (o instanceof FeatureAssociatedExpression) {
            this._format((FeatureAssociatedExpression)o, document);
            return;
        }
        if (o instanceof FeatureSpecification) {
            this._format((FeatureSpecification)o, document);
            return;
        }
        if (o instanceof Module) {
            this._format((Module)o, document);
            return;
        }
        if (o instanceof ProviderBinding) {
            this._format((ProviderBinding)o, document);
            return;
        }
        if (o instanceof TypeBinding) {
            this._format((TypeBinding)o, document);
            return;
        }
        if (o instanceof ValueBinding) {
            this._format((ValueBinding)o, document);
            return;
        }
        if (o instanceof ViewSpecification) {
            this._format((ViewSpecification)o, document);
            return;
        }
        if (o instanceof BindingsSpecification) {
            this._format((BindingsSpecification)o, document);
            return;
        }
        if (o instanceof ExtendsClause) {
            this._format((ExtendsClause)o, document);
            return;
        }
        if (o instanceof FieldSpecification) {
            this._format((FieldSpecification)o, document);
            return;
        }
        if (o instanceof PolymorphicSpecification) {
            this._format((PolymorphicSpecification)o, document);
            return;
        }
        if (o instanceof Model) {
            this._format((Model)o, document);
            return;
        }
        if (o instanceof PartsSpecifications) {
            this._format((PartsSpecifications)o, document);
            return;
        }
        if (o instanceof SimpleMethodSpecification) {
            this._format((SimpleMethodSpecification)o, document);
            return;
        }
        super.format(o, document);
    }

    public void _format(Model model, @Extension IFormattableDocument document) {
        this.format(model.getImportSection(), document);
        this.format(model.getModule(), document);
    }

    public void _format(final Module module, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<Module> _function = new Procedures.Procedure1<Module>(){

            public void apply(Module it) {
                EmfParsleyDslFormatter.this.format(module.getExtendsClause(), document);
                EmfParsleyDslFormatter.this.format(module.getBindingsSpecification(), document);
                EmfParsleyDslFormatter.this.format(module.getLabelProvider(), document);
                EmfParsleyDslFormatter.this.format(module.getTableLabelProvider(), document);
                EmfParsleyDslFormatter.this.format(module.getFeatureCaptionProvider(), document);
                EmfParsleyDslFormatter.this.format(module.getFormFeatureCaptionProvider(), document);
                EmfParsleyDslFormatter.this.format(module.getDialogFeatureCaptionProvider(), document);
                EmfParsleyDslFormatter.this.format(module.getFeaturesProvider(), document);
                EmfParsleyDslFormatter.this.format(module.getTableFeaturesProvider(), document);
                EmfParsleyDslFormatter.this.format(module.getFormControlFactory(), document);
                EmfParsleyDslFormatter.this.format(module.getDialogControlFactory(), document);
                EmfParsleyDslFormatter.this.format(module.getProposalCreator(), document);
                EmfParsleyDslFormatter.this.format(module.getMenuBuilder(), document);
                EmfParsleyDslFormatter.this.format(module.getConfigurator(), document);
                EmfParsleyDslFormatter.this.format(module.getViewerContentProvider(), document);
                EmfParsleyDslFormatter.this.format(module.getTableViewerContentProvider(), document);
                EmfParsleyDslFormatter.this.format(module.getPartsSpecifications(), document);
                EmfParsleyDslFormatter.this.format(module.getResourceManager(), document);
            }
        };
        this.indentBlock(module, document, _function);
    }

    public void _format(ExtendsClause extendsclause, @Extension IFormattableDocument document) {
        this.format(extendsclause.getSuperType(), document);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(this.textRegionExtensions.regionFor((EObject)extendsclause).keyword("extends"), (Procedures.Procedure1)_function);
    }

    public void _format(final BindingsSpecification bindingsspecification, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<BindingsSpecification> _function = new Procedures.Procedure1<BindingsSpecification>(){

            public void apply(BindingsSpecification it) {
                EmfParsleyDslFormatter.this.formatAndSeparateElementsWithNewlines(bindingsspecification.getBindings(), document);
            }
        };
        this.indentBlock(bindingsspecification, document, _function);
    }

    public void _format(TypeBinding typebinding, @Extension IFormattableDocument document) {
        this.oneSpaceAfterKeyword(typebinding, "type", document);
        this.format(typebinding.getTypeToBind(), document);
        this.formatBinding(typebinding, document);
    }

    public void _format(ProviderBinding providerbinding, @Extension IFormattableDocument document) {
        this.oneSpaceAfterKeyword(providerbinding, "provide", document);
        this.format(providerbinding.getType(), document);
        this.formatBinding(providerbinding, document);
    }

    public void _format(ValueBinding valuebinding, @Extension IFormattableDocument document) {
        this.oneSpaceAfterKeyword(valuebinding, "value", document);
        this.format(valuebinding.getTypeDecl(), document);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(this.textRegionExtensions.regionFor((EObject)valuebinding).feature((EStructuralFeature)ModelPackage.Literals.VALUE_BINDING__ID), (Procedures.Procedure1)_function);
        this.formatBinding(valuebinding, document);
    }

    private void formatBinding(Binding binding, @Extension IFormattableDocument document) {
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(this.textRegionExtensions.regionFor((EObject)binding).keyword("->"), (Procedures.Procedure1)_function);
        this.format(binding.getTo(), document);
    }

    public void _format(final LabelProvider labelprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                EmfParsleyDslFormatter.this.formatSpecifications(labelprovider.getTexts(), document);
                EmfParsleyDslFormatter.this.formatSpecifications(labelprovider.getImages(), document);
                EmfParsleyDslFormatter.this.formatSpecifications(labelprovider.getFonts(), document);
                EmfParsleyDslFormatter.this.formatSpecifications(labelprovider.getForegrounds(), document);
                EmfParsleyDslFormatter.this.formatSpecifications(labelprovider.getBackgrounds(), document);
            }
        };
        this.formatWithFields(labelprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(FieldSpecification expr, @Extension IFormattableDocument document) {
        EList<XAnnotation> _annotations = expr.getAnnotations();
        for (XAnnotation annotations : _annotations) {
            this.format(annotations, document);
        }
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.append(this.textRegionExtensions.regionFor((EObject)expr).keyword("val"), (Procedures.Procedure1)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.append(this.textRegionExtensions.regionFor((EObject)expr).keyword("var"), (Procedures.Procedure1)_function_1);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.append(this.textRegionExtensions.regionFor((EObject)expr).keyword("extension"), (Procedures.Procedure1)_function_2);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.append((EObject)expr.getType(), (Procedures.Procedure1)_function_3);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(this.textRegionExtensions.regionFor((EObject)expr).keyword("="), (Procedures.Procedure1)_function_4);
        this.format(expr.getType(), document);
        this.format(expr.getRight(), document);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_5 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        document.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(";"), (Procedures.Procedure1)_function_5);
    }

    public void _format(final TableLabelProvider tablelabelprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(tablelabelprovider.getFeatureTexts(), document);
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(tablelabelprovider.getFeatureImages(), document);
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(tablelabelprovider.getFeatureFonts(), document);
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(tablelabelprovider.getFeatureForegrounds(), document);
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(tablelabelprovider.getFeatureBackgrounds(), document);
                EmfParsleyDslFormatter.this.formatSpecifications(tablelabelprovider.getRowFonts(), document);
                EmfParsleyDslFormatter.this.formatSpecifications(tablelabelprovider.getRowForegrounds(), document);
                EmfParsleyDslFormatter.this.formatSpecifications(tablelabelprovider.getRowBackgrounds(), document);
            }
        };
        this.formatWithFields(tablelabelprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(PolymorphicSpecification specification, @Extension IFormattableDocument document) {
        this.format(specification.getParameterType(), document);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(this.textRegionExtensions.regionFor((EObject)specification).keyword("->"), (Procedures.Procedure1)_function);
        this.format(specification.getExpression(), document);
    }

    public void _format(final FeatureCaptionProvider featurecaptionprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>(){

                    public List<? extends EObject> get() {
                        return featurecaptionprovider.getFeatureTexts().getSpecifications();
                    }
                };
                EmfParsleyDslFormatter.this.indentBlockAndFormatAndSeparateElementsWithNewlines(featurecaptionprovider.getFeatureTexts(), document, (Provider)_function);
            }
        };
        this.formatWithFields(featurecaptionprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final AbstractFeatureCaptionProviderWithLabel featurecaptionprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(featurecaptionprovider.getFeatureTexts(), document);
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(featurecaptionprovider.getFeatureLabels(), document);
            }
        };
        this.formatWithFields(featurecaptionprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(FeatureAssociatedExpression featureassociatedexpression, @Extension IFormattableDocument document) {
        this.format(featureassociatedexpression.getParameterType(), document);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(this.textRegionExtensions.regionFor((EObject)featureassociatedexpression).keyword(":"), (Procedures.Procedure1)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(this.textRegionExtensions.regionFor((EObject)featureassociatedexpression).keyword("->"), (Procedures.Procedure1)_function_1);
        this.format(featureassociatedexpression.getExpression(), document);
    }

    public void _format(final AbstractFeatureProvider featuresprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>(){

                    public List<? extends EObject> get() {
                        return featuresprovider.getFeatures().getFeatureSpecifications();
                    }
                };
                EmfParsleyDslFormatter.this.indentBlockAndFormatAndSeparateElementsWithNewlines(featuresprovider.getFeatures(), document, (Provider)_function);
            }
        };
        this.formatWithFields(featuresprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(FeatureSpecification featurespecification, @Extension IFormattableDocument document) {
        this.format(featurespecification.getParameterType(), document);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(this.textRegionExtensions.regionFor((EObject)featurespecification).keyword("->"), (Procedures.Procedure1)_function);
        List _keywords = this.textRegionExtensions.regionFor((EObject)featurespecification).keywords(new String[]{","});
        for (ISemanticRegion comma : _keywords) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.noSpace();
                }
            };
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.oneSpace();
                }
            };
            document.append(document.prepend(comma, (Procedures.Procedure1)_function_1), (Procedures.Procedure1)_function_2);
        }
    }

    public void _format(final AbstractControlFactory controlfactory, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>(){

                    public List<? extends EObject> get() {
                        return controlfactory.getControls().getSpecifications();
                    }
                };
                EmfParsleyDslFormatter.this.indentBlockAndFormatAndSeparateElementsWithNewlines(controlfactory.getControls(), document, (Provider)_function);
            }
        };
        this.formatWithFields(controlfactory, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(ControlFactorySpecification controlfactoryspecification, @Extension IFormattableDocument document) {
        this.format(controlfactoryspecification.getParameterType(), document);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(this.textRegionExtensions.regionFor((EObject)controlfactoryspecification).keyword(":"), (Procedures.Procedure1)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(this.textRegionExtensions.regionFor((EObject)controlfactoryspecification).keyword("->"), (Procedures.Procedure1)_function_1);
        this.format(controlfactoryspecification.getExpression(), document);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(this.textRegionExtensions.regionFor((EObject)controlfactoryspecification).keyword("target"), (Procedures.Procedure1)_function_2);
        this.format(controlfactoryspecification.getTarget(), document);
    }

    public void _format(final ProposalCreator proposalcreator, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                EmfParsleyDslFormatter.this.formatAndSeparateElementsWithNewlines(proposalcreator.getProposalsSpecifications(), document);
            }
        };
        this.formatWithFields(proposalcreator, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final MenuBuilder menubuilder, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                EmfParsleyDslFormatter.this.formatSpecifications(menubuilder.getMenus(), document);
                EmfParsleyDslFormatter.this.formatSpecifications(menubuilder.getEmfMenus(), document);
            }
        };
        this.formatWithFields(menubuilder, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final Configurator configurator, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                EmfParsleyDslFormatter.this.formatSpecifications(configurator.getResourceURI(), document);
                EmfParsleyDslFormatter.this.formatSpecifications(configurator.getEClassSpec(), document);
            }
        };
        this.formatWithFields(configurator, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final ViewerContentProvider viewercontentprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                EmfParsleyDslFormatter.this.formatSpecifications(viewercontentprovider.getElements(), document);
                EmfParsleyDslFormatter.this.formatSpecifications(viewercontentprovider.getChildren(), document);
            }
        };
        this.formatWithFields(viewercontentprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final TableViewerContentProvider tableviewercontentprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                EmfParsleyDslFormatter.this.formatSpecifications(tableviewercontentprovider.getElements(), document);
            }
        };
        this.formatWithFields(tableviewercontentprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final ResourceManager resourcemanager, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                EmfParsleyDslFormatter.this.format(resourcemanager.getInitializeBody(), document);
                EmfParsleyDslFormatter.this.format(resourcemanager.getSaveBody(), document);
            }
        };
        this.formatWithFields(resourcemanager, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(SimpleMethodSpecification simplemethodspecification, @Extension IFormattableDocument document) {
        this.formatAndSeparateWithNewlines(simplemethodspecification.getBody(), document);
    }

    public void _format(final PartsSpecifications partsspecifications, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<PartsSpecifications> _function = new Procedures.Procedure1<PartsSpecifications>(){

            public void apply(PartsSpecifications it) {
                EmfParsleyDslFormatter.this.formatAndSeparateElementsWithNewlines(partsspecifications.getParts(), document);
            }
        };
        this.indentBlock(partsspecifications, document, _function);
    }

    public void _format(final ViewSpecification viewspecification, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<ViewSpecification> _function = new Procedures.Procedure1<ViewSpecification>(){

            public void apply(ViewSpecification it) {
                boolean _tripleNotEquals;
                Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.oneSpace();
                    }
                };
                document.append(EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification).keyword("viewpart"), (Procedures.Procedure1)_function);
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.oneSpace();
                    }
                };
                document.append(EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification).keyword("viewname"), (Procedures.Procedure1)_function_1);
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.setNewLines(1, 1, 2);
                    }
                };
                document.append(EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification).feature((EStructuralFeature)ModelPackage.Literals.VIEW_SPECIFICATION__VIEW_NAME), (Procedures.Procedure1)_function_2);
                Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.oneSpace();
                    }
                };
                document.append(EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification).keyword("viewclass"), (Procedures.Procedure1)_function_3);
                EmfParsleyDslFormatter.this.format(viewspecification.getType(), document);
                Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.setNewLines(1, 1, 2);
                    }
                };
                document.append((EObject)viewspecification.getType(), (Procedures.Procedure1)_function_4);
                String _category = viewspecification.getCategory();
                boolean bl = _tripleNotEquals = _category != null;
                if (_tripleNotEquals) {
                    Procedures.Procedure1<IHiddenRegionFormatter> _function_5 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                        public void apply(IHiddenRegionFormatter it) {
                            it.oneSpace();
                        }
                    };
                    document.append(EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification).keyword("viewcategory"), (Procedures.Procedure1)_function_5);
                    Procedures.Procedure1<IHiddenRegionFormatter> _function_6 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                        public void apply(IHiddenRegionFormatter it) {
                            it.setNewLines(1, 1, 2);
                        }
                    };
                    document.append(EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification).feature((EStructuralFeature)ModelPackage.Literals.VIEW_SPECIFICATION__CATEGORY), (Procedures.Procedure1)_function_6);
                }
            }
        };
        this.indentBlock(viewspecification, document, _function);
    }

    private WithExtendsClause formatWithFields(final WithFields e, final @Extension IFormattableDocument document, final Procedures.Procedure1<? super WithFields> elementsFormatter) {
        Procedures.Procedure1<WithExtendsClause> _function = new Procedures.Procedure1<WithExtendsClause>(){

            public void apply(WithExtendsClause it) {
                EmfParsleyDslFormatter.this.formatFields(e, document);
                elementsFormatter.apply((Object)e);
            }
        };
        return this.formatWithExtendsClause(e, document, (Procedures.Procedure1<? super WithExtendsClause>)_function);
    }

    private WithExtendsClause formatWithExtendsClause(final WithExtendsClause e, @Extension IFormattableDocument document, final Procedures.Procedure1<? super WithExtendsClause> elementsFormatter) {
        WithExtendsClause _xblockexpression = null;
        this.format(e.getExtendsClause(), document);
        Procedures.Procedure1<WithExtendsClause> _function = new Procedures.Procedure1<WithExtendsClause>(){

            public void apply(WithExtendsClause it) {
                elementsFormatter.apply((Object)e);
            }
        };
        this.indentBlock(e, document, _function);
        _xblockexpression = this.separateElementsWithNewlines(e, document);
        return _xblockexpression;
    }

    private void formatFields(WithFields withFields, @Extension IFormattableDocument document) {
        this.formatAndSeparateElementsWithNewlines((List)withFields.getFields(), document);
    }

    private <T extends EObject> EObject formatSpecifications(final WithExpressions e, @Extension IFormattableDocument document) {
        Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>(){

            public List<? extends EObject> get() {
                return e.getSpecifications();
            }
        };
        return this.indentBlockAndFormatAndSeparateElementsWithNewlines(e, document, _function);
    }

    private <T extends EObject> EObject formatFeatureSpecifications(final WithFeatureAssociatedExpressions e, @Extension IFormattableDocument document) {
        Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>(){

            public List<? extends EObject> get() {
                return e.getSpecifications();
            }
        };
        return this.indentBlockAndFormatAndSeparateElementsWithNewlines(e, document, _function);
    }

    private <T extends EObject> EObject indentBlockAndFormatAndSeparateElementsWithNewlines(EObject parent, final @Extension IFormattableDocument document, Provider<List<? extends T>> elementsProvider) {
        EObject _xifexpression = null;
        if (parent != null) {
            EObject _xblockexpression = null;
            final List list = (List)elementsProvider.get();
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                    EmfParsleyDslFormatter.this.formatAndSeparateElementsWithNewlines(list, document);
                }
            };
            this.indentBlock(parent, document, _function);
            _xifexpression = _xblockexpression = this.separateElementsWithNewlines(parent, document);
        }
        return _xifexpression;
    }

    private <T extends EObject> void formatAndSeparateElementsWithNewlines(List<? extends T> elements, @Extension IFormattableDocument document) {
        for (EObject e : elements) {
            this.formatAndSeparateWithNewlines(e, document);
        }
    }

    private <T extends EObject> T formatAndSeparateWithNewlines(T e, IFormattableDocument document) {
        T _xblockexpression = null;
        this.format(e, document);
        _xblockexpression = this.separateElementsWithNewlines(e, document);
        return _xblockexpression;
    }

    private <T extends EObject> ISemanticRegion oneSpaceAfterKeyword(T element, String k, @Extension IFormattableDocument document) {
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        return document.append(this.textRegionExtensions.regionFor(element).keyword(k), (Procedures.Procedure1)_function);
    }

    private <T extends EObject> T separateElementsWithNewlines(T element, @Extension IFormattableDocument document) {
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.setNewLines(1, 1, 2);
            }
        };
        return (T)document.append(element, (Procedures.Procedure1)_function);
    }

    private <T extends EObject> void indentBlock(T element, @Extension IFormattableDocument document, Procedures.Procedure1<? super T> elementsFormatter) {
        ISemanticRegion open = this.textRegionExtensions.regionFor(element).keyword("{");
        ISemanticRegion close = this.textRegionExtensions.regionFor(element).keyword("}");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.newLine();
            }
        };
        document.append(open, (Procedures.Procedure1)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.indent();
            }
        };
        document.interior(open, close, (Procedures.Procedure1)_function_1);
        elementsFormatter.apply(element);
    }
}

