/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.ui.wizard;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.parsley.dsl.ui.wizard.EmfParsleyDslNewProjectWizardInitialContents;
import org.eclipse.emf.parsley.dsl.ui.wizard.EmfParsleyDslProjectInfo;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.util.PluginProjectFactory;
import org.eclipse.xtext.ui.wizard.AbstractPluginProjectCreator;

public class EmfParsleyDslProjectCreator
extends AbstractPluginProjectCreator {
    protected static final String DSL_PROJECT_NAME = "org.eclipse.emf.parsley.dsl";
    @Inject
    private EmfParsleyDslNewProjectWizardInitialContents initialContents;
    @Inject
    private Provider<EclipseResourceFileSystemAccess2> fileSystemAccessProvider;
    @Inject
    private IOutputConfigurationProvider outputConfigurationProvider;

    protected PluginProjectFactory createProjectFactory() {
        PluginProjectFactory projectFactory = super.createProjectFactory();
        projectFactory.setWithPluginXml(false);
        return projectFactory;
    }

    protected EmfParsleyDslProjectInfo getProjectInfo() {
        return (EmfParsleyDslProjectInfo)super.getProjectInfo();
    }

    protected String getModelFolderName() {
        return "src";
    }

    protected List<String> getAllFolders() {
        Set outputConfigurations = this.outputConfigurationProvider.getOutputConfigurations();
        String outputFolder = "src-gen";
        for (OutputConfiguration outputConfiguration : outputConfigurations) {
            if (!"DEFAULT_OUTPUT".equals(outputConfiguration.getName())) continue;
            outputFolder = outputConfiguration.getOutputDirectory();
            break;
        }
        return ImmutableList.of((Object)this.getModelFolderName(), (Object)outputFolder);
    }

    protected List<String> getRequiredBundles() {
        return Lists.newArrayList((Object[])new String[]{DSL_PROJECT_NAME});
    }

    protected void enhanceProject(IProject project, IProgressMonitor monitor) throws CoreException {
        IFileSystemAccess2 access = this.getFileSystemAccess(project, monitor);
        this.initialContents.generateInitialContents(access);
        project.refreshLocal(2, monitor);
    }

    protected IFileSystemAccess2 getFileSystemAccess(IProject project, IProgressMonitor monitor) {
        EclipseResourceFileSystemAccess2 access = (EclipseResourceFileSystemAccess2)this.fileSystemAccessProvider.get();
        access.setContext((Object)project);
        access.setMonitor(monitor);
        OutputConfiguration defaultOutput = new OutputConfiguration("DEFAULT_OUTPUT");
        defaultOutput.setDescription("Output Folder");
        defaultOutput.setOutputDirectory("./");
        defaultOutput.setOverrideExistingResources(true);
        defaultOutput.setCreateOutputDirectory(true);
        defaultOutput.setCleanUpDerivedResources(false);
        defaultOutput.setSetDerivedProperty(false);
        defaultOutput.setKeepLocalHistory(Boolean.valueOf(false));
        HashMap<String, OutputConfiguration> outputConfigurations = new HashMap<String, OutputConfiguration>();
        outputConfigurations.put("DEFAULT_OUTPUT", defaultOutput);
        access.setOutputConfigurations(outputConfigurations);
        return access;
    }
}

