/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.edit.ui.dnd;

import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.parsley.internal.edit.ui.dnd.DynamicEditingDomainViewerDropAdapter;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;

public class ViewerDragAndDropHelper {
    @Inject
    private MembersInjector<DynamicEditingDomainViewerDropAdapter> membersInjector;

    public void addDragAndDrop(StructuredViewer viewer) {
        this.addDragAndDrop(viewer, null);
    }

    public void addDragAndDrop(StructuredViewer viewer, EditingDomain editingDomain) {
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        if (editingDomain != null) {
            viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(editingDomain, (Viewer)viewer));
        } else {
            DynamicEditingDomainViewerDropAdapter dynamicEditingDomainViewerDropAdapter = new DynamicEditingDomainViewerDropAdapter((Viewer)viewer);
            this.membersInjector.injectMembers((Object)dynamicEditingDomainViewerDropAdapter);
            viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)dynamicEditingDomainViewerDropAdapter);
        }
    }
}

