/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.issues;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.internal.core.util.ComponentPrinter;

public class MWEDiagnostic
extends BasicDiagnostic {
    private static final String ID = "org.eclipse.emf.mwe.core";
    private final Object element;
    private final WorkflowComponent ctx;
    private Throwable throwable;
    private String feature;

    public MWEDiagnostic(int severity, String msg, Object element, String feature, Throwable t, List<Object> additionalData, WorkflowComponent ctx) {
        super(severity, ID, 0, msg, MWEDiagnostic.setup(element, feature, additionalData, ctx));
        this.throwable = t;
        this.element = element;
        this.feature = feature;
        this.ctx = ctx;
    }

    public Throwable getException() {
        if (this.throwable == null) {
            return super.getException();
        }
        return this.throwable;
    }

    private static Object[] setup(Object element, String feature, List<Object> additionalData, WorkflowComponent ctx) {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(0, element);
        data.add(1, feature);
        if (ctx != null) {
            data.add(ctx);
        }
        if (additionalData != null) {
            data.addAll(additionalData);
        }
        return data.toArray();
    }

    public Object getElement() {
        return this.element;
    }

    public WorkflowComponent getContext() {
        return this.ctx;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("[");
        switch (this.severity) {
            case 2: {
                buff.append("WARNING");
                break;
            }
            case 4: {
                buff.append("ERROR");
                break;
            }
            default: {
                buff.append("INFO");
            }
        }
        buff.append("]");
        if (this.getMessage() != null) {
            buff.append(": " + this.getMessage());
        }
        buff.append("(Element: ");
        if (this.getElement() != null) {
            buff.append(this.getElementStringRep());
            if (this.feature != null) {
                buff.append(" Feature: " + this.feature);
            }
        } else {
            buff.append("-UNKNOWN-");
        }
        buff.append("; Reported by: ");
        if (this.getContext() != null) {
            buff.append(ComponentPrinter.getString(this.getContext()));
        } else {
            buff.append("-UNKNOWN-");
        }
        buff.append(")");
        if (this.getException() != null) {
            Throwable t = this.getException();
            StringWriter stringWriter = new StringWriter();
            t.printStackTrace(new PrintWriter(stringWriter));
            buff.append("\n\t " + stringWriter.toString());
        }
        return buff.toString();
    }

    private String getElementStringRep() {
        Object element = this.getElement();
        if (element instanceof EObject) {
            EObject eo = (EObject)element;
            String name = this.getEName(eo);
            if (name == null) {
                return eo.toString();
            }
            StringBuffer qfn = new StringBuffer();
            qfn.append(name);
            while (eo.eContainer() != null) {
                name = this.getEName(eo = eo.eContainer());
                if (name == null) continue;
                qfn.insert(0, String.valueOf(name) + ".");
            }
            return qfn.toString();
        }
        return element.toString();
    }

    private String getEName(EObject eo) {
        EStructuralFeature f = eo.eClass().getEStructuralFeature("name");
        if (f == null) {
            return null;
        }
        Object nameValue = eo.eGet(f);
        if (nameValue instanceof String) {
            return (String)nameValue;
        }
        return null;
    }
}

