/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.common;

import java.util.List;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.ReportService;

public abstract class AbstractRenderer<VELEMENT extends VElement> {
    private final VELEMENT vElement;
    private final ViewModelContext viewModelContext;
    private boolean disposed;
    private final ReportService reportService;

    public AbstractRenderer(VELEMENT vElement, ViewModelContext viewContext, ReportService reportService) {
        if (vElement == null) {
            throw new IllegalArgumentException("vElement must not be null");
        }
        if (viewContext == null) {
            throw new IllegalArgumentException("vContext must not be null");
        }
        if (reportService == null) {
            throw new IllegalArgumentException("reportService must not be null");
        }
        this.vElement = vElement;
        this.viewModelContext = viewContext;
        this.reportService = reportService;
        this.register((VElement)vElement);
    }

    public final ViewModelContext getViewModelContext() {
        this.checkRenderer();
        return this.viewModelContext;
    }

    public final VELEMENT getVElement() {
        this.checkRenderer();
        return this.vElement;
    }

    protected void dispose() {
        this.disposed = true;
        EList adapters = this.vElement.eAdapters();
        if (adapters != null) {
            adapters.removeIf(a -> a.isAdapterForType((Object)this));
        }
    }

    protected void checkRenderer() {
        if (this.disposed) {
            throw new IllegalStateException("Renderer is disposed");
        }
    }

    protected final ReportService getReportService() {
        this.checkRenderer();
        return this.reportService;
    }

    protected void register(VElement viewModelElement) {
        EList adapters = viewModelElement.eAdapters();
        if (adapters != null) {
            viewModelElement.eAdapters().add((Object)new RendererAdapter());
        }
    }

    public static AbstractRenderer<? extends VElement> getRenderer(VElement element, ViewModelContext context) {
        EList adapters = element.eAdapters();
        if (adapters == null) {
            return null;
        }
        RendererAdapter adapter = (RendererAdapter)EcoreUtil.getAdapter((List)adapters, (Object)new ContextKey(context));
        return adapter != null ? adapter.getRenderer() : null;
    }

    private static final class ContextKey {
        private final ViewModelContext context;

        ContextKey(ViewModelContext context) {
            this.context = context;
        }

        boolean hasContext(ViewModelContext context) {
            return this.isInContext(this.context, context);
        }

        private boolean isInContext(ViewModelContext parent, ViewModelContext context) {
            return parent == context || context.getParentContext() != null && this.isInContext(parent, context.getParentContext());
        }
    }

    private final class RendererAdapter
    extends AdapterImpl {
        RendererAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == AbstractRenderer.class || type == AbstractRenderer.this || type instanceof Class && ((Class)type).isInstance(AbstractRenderer.this) || type instanceof ContextKey && ((ContextKey)type).hasContext(AbstractRenderer.this.getViewModelContext());
        }

        AbstractRenderer<? extends VElement> getRenderer() {
            return AbstractRenderer.this;
        }
    }
}

