/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.ui.wizard;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreValidator;
import org.eclipse.emf.ecoretools.design.service.EcoreToolsDesignPlugin;
import org.eclipse.emf.ecoretools.design.ui.wizard.EcoreModelingProjectCreationOperation;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.api.wizards.page.ViewpointsSelectionWizardPage;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class EcoreModelerWizard
extends BasicNewProjectResourceWizard {
    private static final String DESIGN_VIEWPOINT_NAME = "Design";
    private EcoreModelSpecPage modelPage;
    private ViewpointsSelectionWizardPage viewpointsSelectionWizardPage;
    private WizardNewProjectCreationPage wizardNewProjectCreationPage;
    protected IWorkbench workbench;
    protected IPath genModelProjectLocation;
    protected IPath genModelContainerPath;
    protected String initialProjectName;
    protected IStructuredSelection selection;
    private IProject createdProject;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.workbench = workbench;
        this.selection = selection;
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(GenModelEditPlugin.INSTANCE.getImage("full/wizban/NewEmptyEMFProject")));
        this.setWindowTitle(GenModelEditPlugin.INSTANCE.getString("_UI_NewEmptyProject_title"));
        this.setWindowTitle("New Ecore Modeling Project");
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecoretools.design", (String)"icons/full/wizban/EcoreModelingProject_wizban.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.wizardNewProjectCreationPage = new WizardNewProjectCreationPage(SiriusEditPlugin.getPlugin().getString("_UI_ModelingProjectWizard_label")){

            public void createControl(Composite parent) {
                super.createControl(parent);
                Composite control = (Composite)this.getControl();
                GridLayout layout = new GridLayout();
                control.setLayout((Layout)layout);
                this.createWorkingSetGroup(control, (IStructuredSelection)new StructuredSelection(), new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.pde.ui.pluginWorkingSet", "org.eclipse.ui.resourceWorkingSetPage"});
                Dialog.applyDialogFont((Control)control);
            }

            protected boolean validatePage() {
                if (super.validatePage()) {
                    IPath locationPath = this.getLocationPath();
                    EcoreModelerWizard.this.genModelProjectLocation = Platform.getLocation().equals((Object)locationPath) ? null : locationPath;
                    IPath projectPath = this.getProjectHandle().getFullPath();
                    EcoreModelerWizard.this.genModelContainerPath = projectPath.append("src");
                    this.updateModelPagePackageName(this.getProjectName());
                    return true;
                }
                return false;
            }

            private void updateModelPagePackageName(String projectName) {
                String packageName;
                if (!StringUtil.isEmpty((String)projectName) && !StringUtil.isEmpty((String)(packageName = EcoreModelerWizard.this.getPackageName(projectName)))) {
                    EcoreModelerWizard.this.modelPage.setPackageNameSilently(packageName);
                }
            }
        };
        this.wizardNewProjectCreationPage.setInitialProjectName(this.initialProjectName);
        this.wizardNewProjectCreationPage.setTitle("Create a new Ecore Modeling project");
        this.wizardNewProjectCreationPage.setDescription("Enter a project name");
        this.modelPage = new EcoreModelSpecPage("Ecore model parameters");
        this.modelPage.setTitle("Model settings");
        this.modelPage.setDescription("Define the model settings");
        this.viewpointsSelectionWizardPage = new ViewpointsSelectionWizardPage(null, Lists.newArrayList((Object[])new String[]{DESIGN_VIEWPOINT_NAME})){

            protected Collection<String> computeSemanticFileExtensions(Session session) {
                HashSet<String> fileExtensions = new HashSet<String>();
                fileExtensions.add("ecore");
                return fileExtensions;
            }
        };
        ReflectionHelper.setFieldValueWithoutException((Object)((Object)this), (String)"newProjectCreationPage", (Object)this.wizardNewProjectCreationPage);
        this.addPage((IWizardPage)this.wizardNewProjectCreationPage);
        this.addPage((IWizardPage)this.modelPage);
        this.addPage((IWizardPage)this.viewpointsSelectionWizardPage);
    }

    public boolean performFinish() {
        Status status;
        boolean finished = true;
        this.updatePerspective();
        final EcoreModelingProjectCreationOperation ecoreModelingProjectCreationOperation = new EcoreModelingProjectCreationOperation((EObject)this.modelPage.getEPackage(), this.modelPage.getEcoreFileName(), this.modelPage.getGenModelFileName(), this.modelPage.getRepresentationFileName(), new LinkedHashSet<Viewpoint>(this.viewpointsSelectionWizardPage.getViewpoints()), this.workbench, this.genModelContainerPath, this.genModelProjectLocation, this.wizardNewProjectCreationPage.getSelectedWorkingSets());
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)ecoreModelingProjectCreationOperation);
        }
        catch (InvocationTargetException e) {
            status = new Status(4, "org.eclipse.emf.ecoretools.design", 4, e.getMessage(), (Throwable)e);
            EcoreToolsDesignPlugin.INSTANCE.log((Object)status);
            finished = false;
        }
        catch (InterruptedException e) {
            status = new Status(4, "org.eclipse.emf.ecoretools.design", 4, e.getMessage(), (Throwable)e);
            EcoreToolsDesignPlugin.INSTANCE.log((Object)status);
            finished = false;
        }
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Open the diagram metamodel", 2);
                        IFile ecoreModel = ecoreModelingProjectCreationOperation.getEcoreModel();
                        EcoreModelerWizard.this.createdProject = ecoreModelingProjectCreationOperation.getNewProject();
                        if (ecoreModel != null && ecoreModel.exists()) {
                            EcoreModelerWizard.this.selectAndReveal((IResource)ecoreModel);
                        } else {
                            EcoreModelerWizard.this.selectAndReveal((IResource)ecoreModelingProjectCreationOperation.getNewProject());
                        }
                        monitor.worked(1);
                        EcoreModelerWizard.this.openFirstRepresentation(ecoreModelingProjectCreationOperation.getNewProject(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            status = new Status(4, "org.eclipse.emf.ecoretools.design", 4, e.getMessage(), (Throwable)e);
            EcoreToolsDesignPlugin.INSTANCE.log((Object)status);
            finished = false;
        }
        catch (InterruptedException e) {
            status = new Status(4, "org.eclipse.emf.ecoretools.design", 4, e.getMessage(), (Throwable)e);
            EcoreToolsDesignPlugin.INSTANCE.log((Object)status);
            finished = false;
        }
        return finished;
    }

    public IProject getNewProject() {
        return this.createdProject;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        EclipseUIUtil.expand((IResource)newResource, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
    }

    private void openFirstRepresentation(IProject project, IProgressMonitor monitor) {
        Session session;
        Option opionalModelingProject = ModelingProject.asModelingProject((IProject)project);
        if (opionalModelingProject.some() && (session = ((ModelingProject)opionalModelingProject.get()).getSession()) != null && !session.getSelectedViews().isEmpty()) {
            LinkedHashSet representationsToOpen = Sets.newLinkedHashSet();
            for (DView view : session.getSelectedViews()) {
                for (DRepresentation dRepresentation : new DViewQuery(view).getLoadedRepresentations()) {
                    representationsToOpen.add(dRepresentation);
                }
            }
            for (DRepresentation dRepresentation : representationsToOpen) {
                DialectUIManager.INSTANCE.openEditor(session, dRepresentation, monitor);
            }
        }
    }

    public void setInitialProjectName(String value) {
        this.initialProjectName = value;
    }

    private String getPackageName(String projectName) {
        String packageName = String.valueOf(projectName.substring(0, 1).toLowerCase()) + projectName.substring(1);
        int index = packageName.lastIndexOf(46);
        if (index != -1) {
            packageName = packageName.substring(index + 1);
        }
        return packageName;
    }

    private class EcoreModelSpecPage
    extends WizardPage {
        private static final String NAMESPACE_GROUP_LABEL = "Namespace properties";
        private static final String NS_PREFIX_FIELD_LABEL = "Ns Prefix";
        private static final String NS_URI_FIELD_LABEL = "Ns Uri";
        private static final String USE_DEFAULT_LABEL = "Use default namespace parameters";
        private static final String PACKAGE_FIELD_LABEL = "Main package name";
        private static final String DEFAULT_URI_BASE = "http://www.example.org/";
        private static final String DEFAULT_COMMON_FILE_NAME = "model";
        private Text packageNameField;
        private Text nsPrefixField;
        private Text nsUriField;
        private Button useDefaultsButton;
        private EPackage ePackage;
        private boolean silentModificationEnabled;
        private final ModifyListener nsModifyListener;

        public EcoreModelSpecPage(String name) {
            super(name);
            this.silentModificationEnabled = true;
            this.nsModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (EcoreModelSpecPage.this.useDefaultsButton == null || !EcoreModelSpecPage.this.useDefaultsButton.getSelection()) {
                        EcoreModelSpecPage.this.setPageComplete(EcoreModelSpecPage.this.validatePage());
                    }
                }
            };
        }

        public void setPackageNameSilently(String packageName) {
            if (this.packageNameField != null && this.silentModificationEnabled) {
                this.packageNameField.setText(packageName);
            }
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            this.createModelGroup(composite);
            this.createNamespaceGroup(composite, false);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
        }

        private void createModelGroup(Composite parent) {
            this.packageNameField = this.createLabelAndText(parent, PACKAGE_FIELD_LABEL, this.getPackageName());
            this.packageNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (EcoreModelSpecPage.this.packageNameField.isVisible()) {
                        EcoreModelSpecPage.this.silentModificationEnabled = false;
                    }
                    EcoreModelSpecPage.this.updateNamespaceValues();
                    EcoreModelSpecPage.this.setPageComplete(EcoreModelSpecPage.this.validatePage());
                }
            });
        }

        private void createNamespaceGroup(Composite composite, boolean custom) {
            Group nsGroup = new Group(composite, 0);
            nsGroup.setFont(composite.getFont());
            nsGroup.setText(NAMESPACE_GROUP_LABEL);
            nsGroup.setLayoutData((Object)new GridData(4, 128, true, false));
            nsGroup.setLayout((Layout)new GridLayout(1, false));
            this.useDefaultsButton = new Button((Composite)nsGroup, 131104);
            this.useDefaultsButton.setText(USE_DEFAULT_LABEL);
            GridData buttonData = new GridData();
            buttonData.horizontalSpan = 4;
            this.useDefaultsButton.setLayoutData((Object)buttonData);
            this.useDefaultsButton.setSelection(!custom);
            this.nsUriField = this.createLabelAndText((Composite)nsGroup, NS_URI_FIELD_LABEL, this.getNsUri());
            this.nsPrefixField = this.createLabelAndText((Composite)nsGroup, NS_PREFIX_FIELD_LABEL, this.getNsPRefix());
            this.nsUriField.addModifyListener(this.nsModifyListener);
            this.nsPrefixField.addModifyListener(this.nsModifyListener);
            this.setNameSpaceGroupActivation(custom);
            this.useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean useDefault = EcoreModelSpecPage.this.useDefaultsButton.getSelection();
                    if (useDefault) {
                        EcoreModelSpecPage.this.updateNamespaceValues();
                    }
                    EcoreModelSpecPage.this.setNameSpaceGroupActivation(!useDefault);
                    EcoreModelSpecPage.this.setPageComplete(EcoreModelSpecPage.this.validatePage());
                }
            });
        }

        private void setNameSpaceGroupActivation(boolean enabled) {
            if (this.nsUriField != null) {
                this.nsUriField.setEnabled(enabled);
            }
            if (this.nsPrefixField != null) {
                this.nsPrefixField.setEnabled(enabled);
            }
        }

        private void updateNamespaceValues() {
            if (this.useDefaultsButton != null && this.useDefaultsButton.getSelection()) {
                String packageName = this.getPackageName();
                if (this.nsPrefixField != null) {
                    this.nsPrefixField.setText(packageName);
                }
                if (this.nsUriField != null) {
                    this.nsUriField.setText(this.getDefaultNsUri(packageName));
                }
            }
        }

        private Text createLabelAndText(Composite parent, String label, String initialValue) {
            Composite group = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            Label labelField = new Label(group, 0);
            labelField.setText(label);
            labelField.setFont(parent.getFont());
            Text textField = new Text(group, 2048);
            GridData data = new GridData(768);
            data.widthHint = 250;
            textField.setLayoutData((Object)data);
            textField.setFont(parent.getFont());
            if (initialValue != null) {
                textField.setText(initialValue);
            }
            return textField;
        }

        public EPackage getEPackage() {
            if (this.ePackage == null) {
                this.initEPackage();
            }
            return this.ePackage;
        }

        private void initEPackage() {
            EClass eClass = (EClass)EcorePackage.eINSTANCE.getEClassifier("EPackage");
            EObject rootObject = EcoreFactory.eINSTANCE.create(eClass);
            if (rootObject instanceof EPackage) {
                this.ePackage = (EPackage)rootObject;
                this.updateEPackage(this.ePackage);
            }
        }

        private void updateEPackage(EPackage p) {
            p.setName(this.getPackageName());
            p.setNsPrefix(this.getNsPRefix());
            p.setNsURI(this.getNsUri());
        }

        protected boolean validatePage() {
            boolean validEPackage;
            if (this.ePackage == null) {
                this.initEPackage();
            } else {
                this.updateEPackage(this.ePackage);
            }
            EcoreValidator validator = new EcoreValidator();
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            boolean validName = validator.validateENamedElement_WellFormedName((ENamedElement)this.ePackage, (DiagnosticChain)diagnostic, null);
            boolean validNsUri = validator.validateEPackage_WellFormedNsURI(this.ePackage, (DiagnosticChain)diagnostic, null);
            boolean validNsPrefix = validator.validateEPackage_WellFormedNsPrefix(this.ePackage, (DiagnosticChain)diagnostic, null);
            boolean bl = validEPackage = validName && validNsUri && validNsPrefix;
            if (validEPackage) {
                this.setErrorMessage(null);
            } else {
                StringBuilder sb = new StringBuilder();
                this.buildCompoundMessage(sb, (Diagnostic)diagnostic);
                this.setErrorMessage(sb.toString());
            }
            return validEPackage;
        }

        private void buildCompoundMessage(StringBuilder sb, Diagnostic diagnostic) {
            if (!StringUtil.isEmpty((String)diagnostic.getMessage()) && diagnostic.getSeverity() != 0) {
                sb.append(diagnostic.getMessage());
                sb.append("\n");
            }
            for (Diagnostic child : diagnostic.getChildren()) {
                this.buildCompoundMessage(sb, child);
            }
        }

        private String getPackageName() {
            if (this.packageNameField == null) {
                return DEFAULT_COMMON_FILE_NAME;
            }
            return this.packageNameField.getText().trim();
        }

        private String getNsUri() {
            if (this.nsUriField == null) {
                return this.getDefaultNsUri(this.getPackageName());
            }
            return this.nsUriField.getText().trim();
        }

        private String getDefaultNsUri(String packageName) {
            return DEFAULT_URI_BASE + packageName;
        }

        private String getNsPRefix() {
            if (this.nsPrefixField == null) {
                return this.getPackageName();
            }
            return this.nsPrefixField.getText().trim();
        }

        public String getRepresentationFileName() {
            return String.valueOf(this.getPackageName()) + "." + "aird";
        }

        public String getEcoreFileName() {
            return String.valueOf(this.getPackageName()) + ".ecore";
        }

        public String getGenModelFileName() {
            return String.valueOf(this.getPackageName()) + ".genmodel";
        }
    }
}

