/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.provider.custom;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.provider.ExtendedAdapterFactoryItemDelegator;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.uml2.internal.MultiplicityElementChange;
import org.eclipse.emf.compare.uml2.internal.provider.custom.UMLDiffCustomItemProvider;
import org.eclipse.emf.ecore.EObject;

public class MultiplicityElementCustomItemProvider
extends UMLDiffCustomItemProvider {
    private ExtendedAdapterFactoryItemDelegator itemDelegator = new ExtendedAdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public MultiplicityElementCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public IStyledString.IComposedStyledString getStyledText(Object object) {
        MultiplicityElementChange diff = (MultiplicityElementChange)object;
        ComposedStyledString styledText = new ComposedStyledString(this.getInternalText(diff));
        String changedFeature = this.getChangedFeatureText(diff);
        styledText.append(" [" + changedFeature, IStyledString.Style.DECORATIONS_STYLER);
        switch (diff.getKind()) {
            case ADD: {
                styledText.append(" add", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                styledText.append(" delete", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case CHANGE: {
                styledText.append(" change", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + diff.getKind());
            }
        }
        styledText.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return styledText;
    }

    private String getChangedFeatureText(MultiplicityElementChange diff) {
        return diff.getDiscriminant().eContainmentFeature().getName();
    }

    private String getInternalText(MultiplicityElementChange diff) {
        EObject discriminant = diff.getDiscriminant();
        String text = this.itemDelegator.getText((Object)discriminant);
        if (text == null) {
            text = "<null>";
        }
        return text;
    }
}

