/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyItem;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

class PropertyAccessor
implements ICompareAccessor {
    final PropertyItem rootPropertyItem;
    private PropertyItem initialItem;

    public PropertyAccessor(EMFCompareConfiguration configuration, Object object, IMergeViewer.MergeViewerSide side) {
        this.rootPropertyItem = PropertyItem.createPropertyItem(configuration, object, side);
    }

    public PropertyItem getRootPropertyItem() {
        return this.rootPropertyItem;
    }

    public String getName() {
        return this.rootPropertyItem.getText();
    }

    public Image getImage() {
        return ExtendedImageRegistry.INSTANCE.getImage(this.rootPropertyItem.getImage());
    }

    public String getType() {
        return "property";
    }

    public Comparison getComparison() {
        return this.rootPropertyItem.getConfiguration().getComparison();
    }

    public IMergeViewerItem getInitialItem() {
        return this.initialItem;
    }

    public ImmutableList<? extends IMergeViewerItem> getItems() {
        return ImmutableList.copyOf(this.rootPropertyItem.getPropertyItems());
    }

    public void setInitialItem(Diff diff) {
        this.initialItem = this.findPropertyItem(diff, (List<PropertyItem>)this.rootPropertyItem.getPropertyItems());
        if (this.initialItem == null && diff != null) {
            this.initialItem = this.findPropertyItem(null, (List<PropertyItem>)this.rootPropertyItem.getPropertyItems());
        }
    }

    private PropertyItem findPropertyItem(Diff diff, List<PropertyItem> propertyItems) {
        for (PropertyItem propertyItem : propertyItems) {
            PropertyItem result;
            if (this.isPropertyItemForDiff(diff, propertyItem) || diff == null && this.isPropertyItemModifiedOrHasDiff(propertyItem)) {
                return propertyItem;
            }
            if (!propertyItem.hasChildren((Object)propertyItem) || (result = this.findPropertyItem(diff, (List<PropertyItem>)propertyItem.getPropertyItems())) == null) continue;
            return result;
        }
        return null;
    }

    private boolean isPropertyItemForDiff(Diff diff, PropertyItem propertyItem) {
        return diff != null && propertyItem.getDiff() == diff;
    }

    private boolean isPropertyItemModifiedOrHasDiff(PropertyItem propertyItem) {
        return propertyItem.getDiff() != null || propertyItem.isModified();
    }

    public void setInitialItem(PropertyItem propertyItem) {
        PropertyItem sidePropertyItem;
        this.initialItem = propertyItem == null ? null : ((sidePropertyItem = propertyItem.getSide(this.rootPropertyItem.getSide())) == null ? null : (sidePropertyItem.getRootItem() != this.rootPropertyItem ? this.rootPropertyItem.findItem(sidePropertyItem) : sidePropertyItem));
    }
}

