/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.celleditor;

import org.eclipse.emf.common.ui.celleditor.BasicTableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class SingleColumnTableEditor
extends BasicTableEditor
implements MouseListener,
SelectionListener,
TraverseListener {
    protected int editableColumn;
    protected int editorFocusLostTime;
    protected TableItem editorFocusLostItem;

    public SingleColumnTableEditor(Table table) {
        this(table, table.getColumnCount() - 1);
    }

    public SingleColumnTableEditor(Table table, int editableColumn) {
        super(table);
        this.editableColumn = editableColumn;
        table.addMouseListener((MouseListener)this);
        table.addSelectionListener((SelectionListener)this);
        table.addTraverseListener((TraverseListener)this);
    }

    public void dispose() {
        if (this.table != null) {
            this.table.removeMouseListener((MouseListener)this);
            this.table.removeSelectionListener((SelectionListener)this);
            this.table.removeTraverseListener((TraverseListener)this);
            this.table = null;
        }
        this.editorFocusLostItem = null;
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        TableItem item = this.getSelection();
        if (item != null) {
            this.edit(item, this.editableColumn);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        TableItem item;
        if (e.time != this.editorFocusLostTime) {
            this.editorFocusLostItem = null;
        }
        if ((item = this.getItem(e.x, e.y)) != null && item != this.getSelection()) {
            this.table.setSelection(item);
        }
    }

    public void mouseUp(MouseEvent e) {
        TableItem item = this.getItem(e.x, e.y);
        if (item != null && !item.equals(this.editorFocusLostItem)) {
            this.edit(item, this.editableColumn);
        }
    }

    protected TableItem getItem(int x, int y) {
        int tableWidth = this.table.getClientArea().width;
        TableItem[] items = this.table.getItems();
        int row = this.table.getTopIndex();
        while (row < items.length) {
            TableItem item = items[row];
            Rectangle bounds = item.getBounds(0);
            bounds.width = tableWidth - bounds.x;
            if (bounds.contains(x, y)) {
                return item;
            }
            ++row;
        }
        return null;
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.detail == 4) {
            e.doit = false;
        }
    }

    protected boolean canEdit(TableItem item, int column) {
        return column == this.editableColumn;
    }

    protected Text createTextEditor(final TableItem item, int column) {
        Text text = super.createTextEditor(item, column);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SingleColumnTableEditor.this.editorFocusLostTime = e.time;
                SingleColumnTableEditor.this.editorFocusLostItem = item;
            }
        });
        return text;
    }
}

