/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.widgets;

import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.IHistory;
import org.eclipse.net4j.util.collection.PreferenceHistory;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.widgets.HistoryText;
import org.eclipse.net4j.util.ui.widgets.PreferenceButton;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SessionComposite
extends Composite {
    private IHistory<String> connectorHistory = new PreferenceHistory(OM.PREF_HISTORY_CONNECTORS);
    private IHistory<String> repositoryHistory = new PreferenceHistory(OM.PREF_HISTORY_REPOSITORIES);
    private HistoryText connectorText;
    private Label exampleLabel;
    private HistoryText repositoryText;
    private PreferenceButton automaticButton;
    private String connectorDescription;
    private String repositoryName;
    private boolean automaticRegistry;

    public SessionComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(UIUtil.createGridData());
        this.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)this, 0).setText(Messages.getString("SessionComposite.0"));
        this.connectorText = new HistoryText((Composite)this, 2052, this.connectorHistory);
        this.connectorText.getCombo().setLayoutData((Object)new GridData(4, 1, true, false));
        this.connectorText.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SessionComposite.this.connectorDescription = SessionComposite.this.connectorText.getText();
            }
        });
        if (this.connectorHistory.isEmpty()) {
            new Label((Composite)this, 0);
            this.exampleLabel = new Label((Composite)this, 0);
            this.exampleLabel.setText(Messages.getString("SessionComposite.1"));
            this.exampleLabel.setForeground(this.getShell().getDisplay().getSystemColor(16));
        }
        new Label((Composite)this, 0).setText(Messages.getString("SessionComposite.2"));
        this.repositoryText = new HistoryText((Composite)this, 2052, this.repositoryHistory);
        this.repositoryText.getCombo().setLayoutData((Object)new GridData(150, -1));
        this.repositoryText.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SessionComposite.this.repositoryName = SessionComposite.this.repositoryText.getText();
            }
        });
        new Label((Composite)this, 0);
        this.automaticButton = new PreferenceButton((Composite)this, 32, Messages.getString("SessionComposite.3"), OM.PREF_AUTOMATIC_PACKAGE_REGISTRY);
        this.automaticButton.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionComposite.this.automaticRegistry = SessionComposite.this.automaticButton.getSelection();
            }
        });
        this.connectorText.setFocus();
        this.connectorText.getCombo().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (SessionComposite.this.exampleLabel != null) {
                    SessionComposite.this.exampleLabel.setVisible(true);
                }
            }

            public void focusLost(FocusEvent e) {
                if (SessionComposite.this.exampleLabel != null) {
                    SessionComposite.this.exampleLabel.setVisible(false);
                }
            }
        });
        this.connectorDescription = this.connectorText.getText();
        this.repositoryName = this.repositoryText.getText();
        this.automaticRegistry = this.automaticButton.getSelection();
    }

    public IHistory<String> getConnectorHistory() {
        return this.connectorHistory;
    }

    public IHistory<String> getRepositoryHistory() {
        return this.repositoryHistory;
    }

    public HistoryText getConnectorText() {
        return this.connectorText;
    }

    public Label getExampleLabel() {
        return this.exampleLabel;
    }

    public HistoryText getRepositoryText() {
        return this.repositoryText;
    }

    public PreferenceButton getAutomaticButton() {
        return this.automaticButton;
    }

    public boolean isAutomaticRegistry() {
        return this.automaticRegistry;
    }

    public String getSessionDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.connectorDescription);
        if (this.connectorDescription.contains("?")) {
            builder.append("&");
        } else {
            builder.append("?");
        }
        builder.append("repositoryName=");
        builder.append(this.repositoryName);
        if (this.automaticRegistry) {
            builder.append("&automaticPackageRegistry=true");
        }
        return builder.toString();
    }

    public boolean isDescriptionValid() {
        URI uri = URI.createURI((String)this.getSessionDescription());
        return uri.hasAuthority() && uri.host() != null && !StringUtil.isEmpty((String)uri.host()) && !StringUtil.isEmpty((String)this.repositoryName);
    }

    public void rememberSettings() {
        this.connectorText.getHistory().add((Object)this.connectorDescription);
        this.repositoryText.getHistory().add((Object)this.repositoryName);
        this.automaticButton.getPreference().setValue((Object)this.automaticRegistry);
    }

    public void addListener(int eventType, Listener listener) {
        super.addListener(eventType, listener);
        this.connectorText.addListener(eventType, listener);
        this.repositoryText.addListener(eventType, listener);
        this.automaticButton.addListener(eventType, listener);
    }

    public void removeListener(int eventType, Listener listener) {
        super.removeListener(eventType, listener);
        this.connectorText.removeListener(eventType, listener);
        this.repositoryText.removeListener(eventType, listener);
        this.automaticButton.removeListener(eventType, listener);
    }
}

